      subroutine quad(a, b1, c, sr, si, lr, li)
c calculate the zeros of the quadratic a*z**2+b1*z+c.
c the quadratic formula, modified to avoid
c overflow, is used to find the larger zero if the
c zeros are real and both zeros are complex.
c the smaller real zero is found directly from the
c product of the zeros c/a.
      double precision a, b1, c, sr, si, lr, li, b,
     * d, e, dabs, dsqrt
      if (a.ne.0.d0) go to 20
      sr = 0.d0
      if (b1.ne.0.d0) sr = -c/b1
      lr = 0.d0
   10 si = 0.d0
      li = 0.d0
      return
   20 if (c.ne.0.d0) go to 30
      sr = 0.d0
      lr = -b1/a
      go to 10
c compute discriminant avoiding overflow
   30 b = b1/2.d0
      if (dabs(b).lt.dabs(c)) go to 40
      e = 1.d0 - (a/b)*(c/b)
      d = dsqrt(dabs(e))*dabs(b)
      go to 50
   40 e = a
      if (c.lt.0.d0) e = -a
      e = b*(b/dabs(c)) - e
      d = dsqrt(dabs(e))*dsqrt(dabs(c))
   50 if (e.lt.0.d0) go to 60
c real zeros
      if (b.ge.0.d0) d = -d
      lr = (-b+d)/a
      sr = 0.d0
      if (lr.ne.0.d0) sr = (c/lr)/a
      go to 10
c complex conjugate zeros
   60 sr = -b/a
      lr = sr
      si = dabs(d/a)
      li = -si
      return
      end
