*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     DOUBLE PRECISION FUNCTION FLERR2 (R, H, P, N)
*
*
* Purpose:
*     Calculate the mean-square filtering error
*
*
* Description:
*     This function calculates the mean-square error for a linear
*     estimation problem.  Given a random stationary input signal
*     x(k), characterized by an autocorrelation function,
*     R(i) = E[x(k+i) x(i)], this routine finds the mean-square error
*     for y(k), a linearly filtered version of x(k),
*
*               N
*       y(k) = SUM h(i) x(k-M(i)) ,
*              i=1
*
*     where M(i) is a set of delay values.  The error is expressed as
*     e(k)=y(k)-x(k), and the mean-square error is E[e(k)**2].  The
*     resulting mean-square error in vector-matrix notation is,
*
*       E = R(0) - h' p + h' A h ,
*
*     where p(i) = E[x(k) x(k-M(i))], and A(i,j) = E[x(i) x(j)].  The
*     elements of the autocorrelation matrix A, can be expressed as
*     A(i,j) = R(|i-j|).
*
*
* Parameters:
* D <-  FLERR2 - Resulting mean-square error (double precision)
*
* D ->  R      - Double precision N element vector of autocorrelation
*                values. Let this vector have elements R(0),...,R(N-1).
*                Then element R(i) is the autocorrelation at lag i.
* D ->  H      - Double precision N element vector of filter
*                coefficients.  Coefficient H(i) is the filter
*                coefficient corresponding to lag M(i).
* D ->  P      - Double precision N element vector of autocorrelation
*                values.  Element P(i) is the autocorrelation at lag
*                M(i).
* I ->  N      - Number of elements in each of R, H and P.
*
*
* Routines required:
*     None
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 05:17:29 $
*
*
*-----------------------------------------------------------------------

      DOUBLE PRECISION FUNCTION FLERR2 (R, H, P, N)


      INTEGER N
      INTEGER I,J

      DOUBLE PRECISION R(0:N-1),H(N),P(N)
      DOUBLE PRECISION E,SUM


* Calculate the resulting mean-square error
      E=0D0
      DO 200 I=1,N

        SUM=0D0
        DO 120 J=1,I
          SUM=SUM + R(I-J)*H(J)
 120    CONTINUE
        DO 140 J=I+1,N
          SUM=SUM + R(J-I)*H(J)
 140    CONTINUE
        E=E + H(I)*(2.*P(I)-SUM)

 200  CONTINUE

      FLERR2=R(0)-E


      RETURN

      END
