*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE FIRCHK (FREQ, VAL, WEIGHT, VLIML, VLIMU,
*                        ITYPE, NTAP)
*
*
* Purpose:
*     Check FIR filter design specifications
*
*
* Description:
*     This subroutine checks filter design specifications.  If an error
*     is detected, a message is signalled and execution is halted.
*
*
* Parameters:
* R ->  FREQ   - Normalized frequency
* R ->  VAL    - Desired value
* R ->  WEIGHT - Desired weighting value
* R ->  VLIML  - Lower constraint value
* R->   VLIMU  - Upper constraint value
* I ->  ITYPE  - Filter type coded as follows.
*                1 - Multiple passband/stopband filter
*                2 - Multiple passband/stopband filter
*                    (sin(X)/X compensation)
*                3 - Differentiator
*                4 - Hilbert transform filter
* I ->  NTAP   - Number of filter coefficients
*
*
* Routines required:
*     HALT   - Print an error message, stop with error status set
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 05:17:32 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE FIRCHK (FREQ, VAL, WEIGHT, VLIML, VLIMU,
     -                   ITYPE, NTAP)


      INTEGER BPF,REC,DIF,HIL
      PARAMETER (BPF=1,REC=2,DIF=3,HIL=4)

      INTEGER ITYPE,NTAP

      LOGICAL SYM,EVEN

      REAL FREQ,VAL,WEIGHT,VLIML,VLIMU


* Check the data values
      IF (FREQ.LT.0.0 .OR. FREQ.GT.0.5)
     -  CALL HALT('FIRCHK - Invalid frequency')
      IF (WEIGHT.LE.0.0)
     -  CALL HALT('FIRCHK - Weight value not positive')
      IF (VLIML.GT.VLIMU .OR. VLIML.GT.VAL .OR. VLIMU.LT.VAL)
     -  CALL HALT('FIRCHK - Invalid constraint value(s)')

* Check the filter type specification
      IF (ITYPE.LT.BPF .OR. ITYPE.GT.HIL)
     -  CALL HALT('FIRCHK - Invalid filter type')

* Check the endpoint specifications
* 1. Hilbert transforms must be zero at zero frequency
* 2. Symmetrical filters (BPF or REC) of even length and
*    anti-symmetrical filters (HIL or DIF) of odd length
*    must be zero at normalized frequency 0.5
      IF (FREQ.LE.0.0 .AND. ITYPE.EQ.HIL .AND. VAL.NE.0.0)
     -  CALL HALT('FIRCHK - Attempt to specify unallowed response '//
     -            'at zero frequency')
      SYM=ITYPE.EQ.BPF .OR. ITYPE.EQ.REC
      EVEN=MOD(NTAP,2).EQ.0
      IF (FREQ.GE.0.5 .AND. (SYM.EQV.EVEN) .AND. VAL.NE.0.0)
     -  CALL HALT('FIRCHK - Attempt to specify unallowed response '//
     -            'at half sampling frequency')


      RETURN

      END
