*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     SUBROUTINE DCONLP (Z, X, NX, Y, NY)
*
*
* Purpose:
*     Convolve symmetric responses
*
*
* Description:
*     This routine computes the convolution sum
*
*              Ku
*       z(i) = SUM x(k) y(i-k) ,  Kl=max(0,i-NY+1), Ku=min(i,NX-1),
*              k=Kl
*
*     where NX is the number of terms in x(0),...,x(NX-1) and NY is the
*     number of terms in y(0),...,y(NY-1).
*
*
* Parameters:
* D <-  Z      - Output vector of length NX+NY-1 (double precsion)
* D ->  X      - Input vector of length NX
* I ->  NX     - Number of elements in the vector X (double precision)
* D ->  Y      - Input vector of length NY
* I ->  NY     - Number of elements in the vector Y (double precision)
*
*
* Routines required:
*     None
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 05:05:56 $
*
*
*-----------------------------------------------------------------------

      SUBROUTINE DCONLP (Z, X, NX, Y, NY)


      INTEGER NX,NY
      INTEGER NXL,NXU,I,KST,KFN,K,KM

      DOUBLE PRECISION Z(0:NX+NY-2),X(0:NX-1),Y(0:NY-1)
      DOUBLE PRECISION SL,SU,SM


* The computation of the convolution sum is separated into two parts
* (plus a middle term).  In the second part, the summation index
* runs backwards. If the input responses are symmetric, the computation
* will process the sum terms in the same order for Z(i) and Z(NZ-1-i).
      NXL=NX/2-1
      NXU=NX-NX/2
      DO 160 I=0,NX+NY-2

        KST=MAX(0,I-NY+1)
        KFN=MIN(I,NX-1)

        SL=0D0
        DO 120 K=KST,MIN(KFN,NXL)
          SL=SL + X(K)*Y(I-K)
 120    CONTINUE

        SU=0D0
        DO 140 K=KFN,MAX(KST,NXU),-1
          SU=SU + X(K)*Y(I-K)
 140    CONTINUE

        IF (MOD(NX,2).NE.0) THEN
          KM=(NX+1)/2-1
          IF (KM.GE.KST .AND. KM.LE.KFN) THEN
            SM=X(KM)*Y(I-KM)
          ELSE
            SM=0D0
          END IF
        ELSE
          SM=0D0
        END IF

        Z(I)=(SL+SU) + SM

 160  CONTINUE


      RETURN

      END
