*------------- Telecommunications & Signal Processing Lab --------------
*                          McGill University
*
*
* Module:
*     DOUBLE PRECISION FUNCTION AMSFIR (F, H, NCOF)
*
*
* Purpose:
*     Find the amplitude response of a symmetric FIR filter
*
*
* Description:
*     This function calculates the frequency response of an FIR filter
*     specified by its coefficients.  The filter is assumed to be
*     symmetric. The total number of coefficients in the filter is odd
*     and of the form 2 Nc - 1.  The response is given by
*
*                       Nc-1
*       H(f) = h(0) + 2 SUM  h(n) cos (2 pi n f) ,
*                       n=1
*
*
* Parameters:
* D <-  AMSFIR - Resulting response value (double precision)
*
* R ->  F      - Normalized frequency (normally in the range
*                0 to 0.5)
* D ->  H      - Filter coefficients (double precision)
* I ->  NCOF   - Number of filter coefficients given.  The overall
*                symmetric response has 2*NCOF-1 coefficients.
*
*
* Routines required:
*     None
*
*
* Author / revision:
*     P. Kabal  Copyright (C) 1993
*     $Revision: 1.3 $  $Date: 1993/01/25 05:05:09 $
*
*
*-----------------------------------------------------------------------

      DOUBLE PRECISION FUNCTION AMSFIR (F, H, NCOF)


      DOUBLE PRECISION PI2
      PARAMETER (PI2=6.283 185 307 179 586 476 9D0)

      INTEGER NCOF
      INTEGER N

      REAL F

      DOUBLE PRECISION H(0:NCOF-1),SUM


      SUM=0D0
      DO 100 N=NCOF-1,1,-1
        SUM=SUM + H(N)*COS(PI2*F*N)
 100  CONTINUE
      AMSFIR=H(0) + 2D0*SUM


      RETURN

      END
