/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STcopyNMax (const char Si[], char So[], int N, int Maxchar)

Purpose:
  Copy N characters characters to a string

Description:
  This routine is used to copy min(N,Maxchar) characters from the input string
  to the output string.  A null character in the input string also terminates
  the transfer at that point.  If N is larger than Maxchar, a string truncated
  warning message is printed.

Parameters:
 <-   int STcopyNMax
      Number of characters in the output string
   -> const char Si[]
      Input character string
  <-  char So[]
      Output character string.  This string is always null terminated, with
      at most Maxchar characters not including the terminating null character.
      If the input string is longer than Maxchar, only the first Maxchar
      characters are copied and a warning message is printed.
   -> int N
      Number of characters to be transferred
   -> int Maxchar
      Maximum number of characters (not including the terminating null
      character) to be placed in So.

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.14 $  $Date: 1995/05/15 02:11:53 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STcopyNMax.c 1.14 1995/05/15 FilterDesign-V1R7a $";

#include <string.h>
#include <libtsp.h>

#define MINV(a, b)	(((a) < (b)) ? (a) : (b))

int
STcopyNMax (Si, So, N, Maxchar)

     const char Si[];
     char So[];
     int N;
     int Maxchar;

{
  const char *si;
  int n;
  int NM;

  /* Save the initial input pointer */
  si = Si;

  /* Copy at most max(N, Maxchar) characters */
  NM = MINV (Maxchar, N);
  for (n = 0; n < NM && *si != '\0'; n++)
    *So++ = *si++;

  /* Add a trailing null */
  *So = '\0';

  /* Check for truncation */
  if (N > Maxchar && n == NM && Si[NM-1] != '\0')
    UTwarn ("STcopyNMax - String truncated, string: \"%.*s...\"", 
	    MINV (20, n), Si);

  /* Return the number of characters in So */
  return n;
}
