/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  nucleus.h

Description:
  Function prototypes for the TSP library internal (nucleus) routines

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.6 $  $Date: 1996/07/15 14:49:10 $

----------------------------------------------------------------------*/

#ifndef nucleus_h_
#define nucleus_h_

#include <stdio.h>	/* typedef for FILE */
			/* also size_t and NULL */
#include <stddef.h>	/* offsetof */
#include <time.h>	/* typedef for time_t */

#ifdef __STDC__
#  define p_(params)	params
#else
#  define const				/* Define const for K&R C */
#  define p_(params)	()
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ----- FL Prototypes ----- */
int
FLexist p_((const char Fname[]));
int
FLfReadTF p_((FILE *fp, int MaxNval, int cc, float x[]));
int
FLjoinNames p_((const char Dname[], const char Bname[], char Fname[]));
int
FLterm p_((FILE *fp));

/* ----- MS Prototypes ----- */
double *
MScoefMC p_((double x1, double x2, double y1, double y2,
	     double d1, double d2));
double
MSevalMC p_((double x, double x1, double x2, double y1, double y2,
	     double d1, double d2));
double
MSslEndMC p_((double Dxr, double Dxrr, double Dyr, double Dyrr));
double
MSslMidMC p_((double Dxl, double Dxr, double Dyl, double Dyr));
double
MSslopeMC p_((int k, const float x[], const float y[], int N));

/* ----- ST Prototypes ----- */
int
STdec1val p_((const char String[], char Type, void *Val));
int
STdecNval p_((const char String[], int Nmin, int Nmax, char Type, void *Val,
	      int *N));
char *
STtrimIws p_((const char Si[]));
int
STtrimNMax p_((const char Si[], char So[], int N, int Maxchar));

/* ----- UT Prototypes ----- */
int
UTdecOption p_((const char String[], const char Option[],
		const char **Arg));

#ifdef __cplusplus
}
#endif

#endif /* nucleus_h_ */
