/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  libtsp.h

Description:
  Function prototypes and declarations for the TSP library routines

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.10 $  $Date: 1996/03/11 02:03:59 $

----------------------------------------------------------------------*/

#ifndef libtsp_h_
#define libtsp_h_

#include <stdio.h>	/* typedef for FILE */
			/* defines FILENAME_MAX */
			/* stdio.h also defines NULL, size_t */

/* For non-ANSI headers */
#ifndef FILENAME_MAX	/* normally in stdio.h */
#  include <sys/param.h>
#  define FILENAME_MAX	MAXPATHLEN
#endif

/* For HPUX */
#ifdef hpux
#  undef FILENAME_MAX	/* defined in stdio.h as 14 */
#  include <sys/param.h>
#  define FILENAME_MAX	MAXPATHLEN
#endif

#ifdef __STDC__
#  define p_(params)	params
#else
#  define p_(params)	()
#  define const				/* Define const for K&R C */
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ----- FL Prototypes ----- */
void
FLbackup p_((const char Fname[]));
int
FLbaseName p_((const char Fname[], char Bname[]));
int
FLdirName p_((const char Fname[], char Bname[]));
int
FLextName p_((const char Fname[], char Ext[]));
int
FLfullName p_((const char Fname[], char Fullname[]));
char *
FLgetLine p_((FILE *fp));
int
FLhomeDir p_((const char User[], char Home[]));
int
FLpreName p_((const char Fname[], char Pname[]));
void
FLprompt p_((const char Prompt[]));
char *
FLreadLine p_((const char Prompt[]));

/* ----- MA Prototypes ----- */
void
MAfPrint p_((FILE *fp, const char Header[], const float *A[], int Nrow,
	     int Ncol));

/* ----- MS Prototypes ----- */
int
MSiCeil p_((int n, int m));
void
MSintMC p_((const float x[], const float y[], int N, const float xi[],
	    float yi[], int Ni));

/* ----- SP Prototypes ----- */
int
SPquant p_((double x, const float Xq[], int Nreg));

/* ----- ST Prototypes ----- */
int
STcatMax p_((const char Si[], char So[], int Maxchar));
int
STcopyMax p_((const char Si[], char So[], int Maxchar));
int
STcopyNMax p_((const char Si[], char So[], int N, int Maxchar));
int
STdec1float p_((const char String[], float *Fval));
int
STdec1int p_((const char String[], int *Ival));
int
STdecNfloat p_((const char String[], int Nmin, int Nmax, float Fval[],
		int *N));
int
STdecNint p_((const char String[], int Nmin, int Nmax, int Ival[],
	      int *N));
char *
STfindToken p_((const char String[], const char Delims[],
		const char Quotes[], char Token[], int WSFlag,
		int Maxchar));
int
STkeyMatch p_((const char String[], const char *KeyTable[]));

/* ----- UT Prototypes ----- */
void
UTerror p_((const char Errmsg[], ...));
void
UTfree p_((void *ptr));
int
UTgetOption p_((int *Index, const int argc, const char *argv[],
		const char *OptTable[], const char **OptArg));
char *
UTgetProg p_((void));
void
UThalt p_((const char Errmsg[], ...));
void *
UTmalloc p_((int size));
void *
UTrealloc p_((void *ptr, int size));
void
UTsetProg p_((const char Program[]));
void
UTwarn p_((const char Warnmsg[], ...));

/* ----- VR Prototypes ----- */
void
VRfPrint p_((FILE *fp, const char Header[], const float x[], int N));

#ifdef __cplusplus
}
#endif

#endif /* libtsp_h_ */
