/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void INreadSpec (double Sfreq, struct PSD *psd, struct PSD *dis)

Purpose:
  Read interpolating filter specifications

Description:
  This routine prompts for and reads specifications for an interpolating
  filter.

Parameters:
   -> double Sfreq
      Sampling frequency
  <-  struct PSD *psd
      Structure describing the continuous power spectral density.  This
      structure contains an array of normalized frequencies and an array of
      the corresponding power spectral values.
  <-  struct PSD *dis
      Structure describing the discrete (sinusoidal) components of the power
      spectrum.  This structure contains an array of normalized frequencies and
      an array of the corresponding powers of the sinusoids.

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.9 $  $Date: 1995/05/26 00:25:16 $


-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: INreadSpec.c 1.9 1995/05/26 FilterDesign-V1R7a $";

#include <libtsp.h>
#include "DFiltInt.h"

#define MAXTOKEN	100

void
INreadSpec (Sfreq, psd, dis)

     double Sfreq;
     struct PSD *psd;
     struct PSD *dis;

{
  int status;
  char *line;
  char *p;
  char token[MAXTOKEN+1];
  float fr, frp;
  float val;
  int n;
  static const char *keytab[] = {"psd", "cos", NULL};

/* Read the values of the power spectrum of the input process */
  FLprompt ("Input signal power spectrum:\n");
  psd->N = 0;
  dis->N = 0;
  frp = -1.0;
  while (1) {

    /* Read a record */
    line = FLreadLine ("  Frequency, Value: ");
    if (line == NULL || line[0] == '\0')
      break;

    /* Pick off the frequency */
    p = STfindToken (line, "", "", token, 2, MAXTOKEN);
    status = STdec1float (token, &fr);
    if (status != 0 || fr < 0.0)
      UThalt ("%s: Invalid frequency", PROGRAM);
    fr = fr / Sfreq;
    if (p == NULL)
      UThalt ("%s: Too few values in specification line", PROGRAM);

    /* Pick off the value */
    p = STfindToken (p, "", "", token, 2, MAXTOKEN);
    status = STdec1float (token, &val);
    if (status != 0 || val < 0.0)
      UThalt ("%s: Invalid power spectrum value", PROGRAM);

    /* Pick off the optional identifier */
    n = 0;
    if (p != NULL) {
      p = STfindToken (p, "", "", token, 2, MAXTOKEN);
      if (p != NULL)
	UThalt ("%s: Too many values in specification line", PROGRAM);
      n = STkeyMatch (token, keytab);
      if (n < 0)
	UThalt ("%s: Invalid power spectrum identifier", PROGRAM);
    }

    /* Update the appropriate values */
    switch (n) {
    case 0:
      if (fr <= frp)
	UThalt ("%s: Improperly ordered frequency", PROGRAM);
      if (psd->N >= MAXPT)
        UThalt ("%s: Too many specification lines", PROGRAM);
      psd->f[psd->N] = fr;
      psd->psd[psd->N] = val;
      ++(psd->N);
      break;
    case 1:
      if (dis->N >= MAXPT)
        UThalt ("%s: Too many spectrum values", PROGRAM);
      dis->f[dis->N] = fr;
      dis->psd[dis->N] = val;
      ++(dis->N);
      break;
    }
  }
}
