/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  DFiltInt.h

Description:
  Declarations for DFiltInt

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.19 $  $Date: 1996/06/17 21:25:56 $

----------------------------------------------------------------------*/

#ifndef DFiltInt_h_
#define DFiltInt_h_

#define PROGRAM "DFiltInt"
#define VERSION	"v2r1  1996/06/16"

#define MAXPT	200	/* Maximum number of power spectrum samples */

struct PSD {
  int N;
  float f[MAXPT];
  float psd[MAXPT];
};

#include <stdio.h>	/* defines FILENAME_MAX */

/* For non-ANSI headers */
#ifndef FILENAME_MAX	/* normally in stdio.h */
#  include <sys/param.h>
#  define FILENAME_MAX	MAXPATHLEN
#endif

/* For HPUX */
#ifdef hpux
#  undef FILENAME_MAX	/* defined in stdio.h as 14 */
#  include <sys/param.h>
#  define FILENAME_MAX	MAXPATHLEN
#endif

#include <libtsp.h>			/* p_ and const */

#ifdef __cplusplus
extern "C" {
#endif

/* Prototypes */
int
INdTpSolve p_((const double R[], const double [], double c[], int N));
void
INdesInt p_((float h[], int Ncof, double Delay, int Ir, const struct PSD *psd,
	     const struct PSD *dis));
double
INevCorr p_((double t, const struct PSD *psd, const struct PSD *dis));
double
INfiltMSE p_((const double rxx[], const double h[], const double p[], int N));
float *
INintMSE p_((const float h[], int Ncof, double Delay, int Ir,
	     const struct PSD *psd, const struct PSD *dis));
void
INoptions p_((int argc, const char *argv[], int *Ncof, float *Delay, int *Ir,
	      float *Sfreq, const char **Fname));
void
INprintSpec p_((int Ncof, double Delay, int Ir, const float mse[],
		double Sfreq, const struct PSD *psd, const struct PSD *dis));
void
INreadSpec p_((double Sfreq, struct PSD *psd, struct PSD *dis));
double
INtimeResp p_((double t, const float f[], const float fresp[], int N));
void
INwriteCof p_((const char Fname[], const float h[], int Ncof, double Delay,
	       int Ir, const struct PSD *psd, const struct PSD *dis));

#ifdef __cplusplus
}
#endif

#endif /* DFiltInt_h_ */
