/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  double MMintVal (double xarg, const struct Pcev *P)

Purpose:
  Evaluate the Lagrange interpolation formula

Description:
  This function calculates the interpolated value of a polynomial using the
  Lagrange interpolation formula in barycentric form.  The interpolation
  formula is as follows.

              N  a(m) y(m)
             SUM ---------
             m=1  x-x(m)                   N        c
    Val(x) = -------------,  where a(m) = PROD  ---------,
                N   a(k)                  i=1   x(m)-x(i)
               SUM ------               (omit m)
               k=1 x-x(k)

  This formula is equivalent to the conventional Lagrange interpolation formula
  which can be expressed as the sum of N polynomials,

              N                               a(m)  N
    Val(x) = SUM y(m) L(m,x), where L(m,x) = ---- PROD  (x-x(i))
             m=1                               c   i=1
                                                 (omit m)

  The equivalence of the two forms can be demonstrated by multiplying numerator
  and denominator of the first formulation by PROD (x-x(i)).  The numerator is
  then in the form of the conventional Lagrange interpolation formula, while
  the denominator is the Lagrange interpolation of a constant.

Parameters:
  <-  double MMintVal
      Interpolated value
   -> double xarg
      Argument value.  The polynomial is evaluated at this point.  This value
      should not correspond to any of the abscissa values, lest a divide by
      zero occur.
   -> const struct Pcev *P
      Structure containing the array of Lagrange interpolation coefficients
      and the corresponding abscissa and ordinate values.  These values
      together specify the polynomial that passes through the points specified.
 
Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.3 $  $Date: 1995/02/09 22:11:05 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: MMintVal.c 1.3 1995/02/09 FilterDesign-V1R7a $";

#include "DFiltFIR.h"

double
MMintVal (xarg, P)

     double xarg;
     const struct Pcev *P;

{
  double den, num, c;
  int i;

  num = 0.0;
  den = 0.0;
  for (i = 0; i < P->N; ++i) {
    c = P->ad[i] / (xarg - P->x[i]);
    den += c;
    num += c * P->y[i];
  }

  return (num / den);
}
