/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void MMintCof (const double x[], double ad[], int N)

Purpose:
  Generate Lagrange interpolation coefficients

Description:
  This subroutine calculates a set of Lagrange interpolation coefficients given
  a set of abscissa values.  The calculated coefficients are calculated as

            N       1/2
    a(k) = PROD  --------- .
            i=1   x(k)-x(i)
          (omit k)

  The factor 1/2 in the numerator is used to prevent the product from getting
  too small for x[i] less than unity.

Parameters:
   -> const double x[]
      Array of (distinct) abscissa values
  <-  double ad[]
      Array of Lagrange interpolation coefficients
   -> int N
      Number of coefficients

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.3 $  $Date: 1995/02/09 22:10:06 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: MMintCof.c 1.3 1995/02/09 FilterDesign-V1R7a $";

#include <libtsp.h>
#include "DFiltFIR.h"

void
MMintCof (x, ad, N)

     const double x[];
     double ad[];
     int N;

{
  int i, k, l;
  double dk, xk;
  int ld;

/* Calculate the interpolation coefficients */
/* The order is scrambled to try to preserve dynamic range. */
  ld = N / 10 + 1;
  for (k = 0; k < N; ++k) {
    dk = 1.0;
    xk = x[k];
    for (l = 0; l < ld; ++l) {
      for (i = l; i < N; i += ld) {
	if (i != k)
	  dk = 2.0 * dk * (xk - x[i]);
      }
    }
    if (dk == 0.0)
      UThalt ("MMintCof: Abscissa values not distinct");
    ad[k] = 1.0 / dk;
  }
}
