/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STdecLrange (const char String[], long int *Lval1, long int *Lval2)

Purpose:
  Decode a range specification for long integer values

Description:
  This routine decodes a string specifying a range of long integer values.  The
  range is specified in the form "Lv" or "Lv1:Lv2", for example "-23 : 45".
  Optional white-space (as defined by isspace) can surround the values.  For
  the case of a single value Lv, this is equivalent to the range "Lv:Lv".  If
  an error is encountered, neither output value is set.

Parameters:
  <-  int STdecIrange
      Error status, 0 for no error, 1 for error
   -> const char String[]
      Input string
  <-  long int *Lval1
      First value
  <-  long int *Lval2
      Second value

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.2 $  $Date: 1996/05/31 19:11:18 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdecLrange.c 1.2 1996/05/31 AFsp-V2R2 $";

#include <math.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>

int
STdecLrange (String, Lval1, Lval2)

     const char String[];
     long int *Lval1;
     long int *Lval2;

{
  int N;
  long int lval1, lval2;

  /* Decode the range values */
  N = STdecPair (String, ":", 'L', (void *) (&lval1), (void *) (&lval2));

  if (N == 1)
    lval2 = lval1;
  if (N > 0) {
    *Lval1 = lval1;
    *Lval2 = lval2;
  }

  return (N <= 0);
}
