/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int STdec1double (const char String[], double *Dval)

Purpose:
  Decode a double value

Description:
  This routine decodes a string containing a numeric value.  The decoded datum
  is stored as a double value.  If a decoding error is detected, a warning
  message is printed and error status is set.  A warning messages is printed
  if extra data follows the requested value (this data is ignored).

Parameters:
  <-  int STdec1double
      Error status, 0 for no error, 1 for error
   -> const char String[]
      Input string
  <-  double *Dval
      Returned value.  This value is not changed if an error status is
      returned.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.2 $  $Date: 1996/05/31 19:08:18 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: STdec1double.c 1.2 1996/05/31 AFsp-V2R2 $";

#include <libtsp.h>
#include <libtsp/nucleus.h>

int
STdec1double (String, Dval)

     const char String[];
     double *Dval;

{
  return (STdec1val (String, 'D', (void *) Dval));
}
