/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int FLreadFile (FILE *fp, long int offs, void *ptr, size_t elem_size,
                  size_t count)

Purpose:
  Read raw data from a file

Description:
  This routine reads raw data from a file.  This routine provides a random
  access interface to fread, with error checking.  If any error is detected
  (other than end-of-file), execution is terminated.

Parameters:
  <-  int FLreadFile
      Number of values read from the file.  This value is less than count only
      if end-of-file is reached.
   -> FILE *fp
      File pointer associated with the file
   -> long int offs
      Byte offset in the file
  <-  void *ptr
      Data buffer
   -> size_t elem_size
      Size of each data element in the output buffer
   -> size_t count
      Number of data elements to be read

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.15 $  $Date: 1995/05/20 10:11:47 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLreadFile.c 1.15 1995/05/20 AFsp-V2R2 $";

#include <stdio.h>
#include <libtsp.h>
#include <libtsp/nucleus.h>

#ifndef SEEK_SET	/* normally defined in stdio.h */
#  include <unistd.h>
#endif

int
FLreadFile (fp, offs, ptr, elem_size, count)

     FILE *fp;
     long int offs;
     void *ptr;
     size_t elem_size;
     size_t count;

{
  int Nval;

  if (fseek (fp, offs, SEEK_SET) != 0)
    UTerror ("FLreadFile: Seek error");

  Nval = fread ((char *) ptr, elem_size, count, fp);	/* Sun CC needs cast */
  if (Nval < count) {
    if (! feof (fp))
      UTerror ("FLreadFile: Read error");
  }
  return Nval;
}
