/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Routine:
  int FLdirName (const char Fname[], char Bname[])

Purpose:
  Return all but the last component of a file path

Description:
  This routine takes a file path specification and returns all but the
  right-most component of the file name.  Components are separated by /
  characters.  If no / character appears in the name, an empty string is
  returned.  For MS-DOS, the directory separator character is \.

  Examples: 
     "abc/def"      => "abc"
     "abc/def/"     => "abc/def"
     "abc/bcd/def"  => "abc/bcd"
     "/abc/def"     => "/abc"
     "/abc/bcd/def" => "/abc/bcd"
     "./def"        => "."
     "def"          => ""
  Special cases: 
     "/def"         => "/"
     "/"            => "/"

Parameters:
  <-  int FLdirName
      Number of characters in the output string
   -> const char Fname[]
      Input character string with the path name
  <-  char Bname[]
      Output string with the all but the last path name component.  This string
      at most FILENAME_MAX characters long not including the terminating null
      character.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.14 $  $Date: 1996/10/23 13:56:16 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLdirName.c 1.14 1996/10/23 AFsp-V2R2 $";

#include <string.h>
#include <libtsp.h>

#ifdef _MSDOS
#  ifndef MSDOS
#    define MSDOS 1	/* For MSVC with /Za option */
#  endif
#endif

#ifdef MSDOS
#  ifndef unix
#    define MSDOS_SEP	/* Use MS-DOS directory separators */
#  endif
#endif

#ifdef MSDOS_SEP
#  define DIR_SEP_CHAR		'\\'
#  define DIR_SEP_STR		"\\"
#else
#  define DIR_SEP_CHAR		'/'
#  define DIR_SEP_STR		"/"
#endif

int
FLdirName (Fname, Dname)

     const char Fname[];
     char Dname[];

{
  char *p;
  int n, nc;

/* Break the string at the last directory separator */
  p = strrchr (Fname, DIR_SEP_CHAR);
  if (p != NULL) {
    nc = p - Fname;
    if (nc == 0)
      n = STcopyMax (DIR_SEP_STR, Dname, FILENAME_MAX);
    else
      n = STcopyNMax (Fname, Dname, nc, FILENAME_MAX);
  }
  else {
    Dname[0] = '\0';
    n = 0;
  }

  return n;
}
