/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  int AFreadU1 (AFILE *AFp, long int offs, float Fbuff[], int Nreq)

Purpose:
  Read offset-binary 8-bit integer data from an audio file (return float)

Description:
  This routine reads a specified number of offset-binary 8-bit integer samples
  from an audio file.  The data in the file is converted to float format on
  output.  The file must have been opened using subroutine AFopenRead.

Parameters:
  <-  int AFreadU1
      Number of data values transferred from the file.  On reaching the end of
      the file, this value may be less than Nreq.
   -> AFILE *AFp
      Audio file pointer for an audio file opened by AFopenRead
   -> long int offs
      Offset into the file in samples.  The parameter offs must be non-
      negative.
  <-  float Fbuff[]
      Array of floats to receive the samples
   -> int Nreq
      Number of samples requested.  Nreq may be zero.

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.1 $  $Date: 1996/08/14 18:03:16 $

-------------------------------------------------------------------------*/

static char rcsid [] = "$Id: AFreadU1.c 1.1 1996/08/14 AFsp-V2R2 $";

#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/AFpar.h>
#include <libtsp/UTtypes.h>

#define LW		FDL_UINT8
#define MINV(a, b)	(((a) < (b)) ? (a) : (b))
#define NBBUF		8192

int
AFreadU1 (AFp, offs, Fbuff, Nreq)

     AFILE *AFp;
     long int offs;
     float Fbuff[];
     int Nreq;

{
  long int offsb;
  int Nd, is, n, i, Nval;
  uint1_t Buf[NBBUF/LW];
  int2_t ival;

  offsb = AFp->Start + LW * offs;
  Nd = (int) MINV (Nreq, (AFp->End - offsb) / LW);  /* Nd can be negative */
  for (is = 0; is < Nd; ) {

    /* Read data from the audio file */
    n = MINV (NBBUF / LW, Nd - is);
    Nval = FLreadFile (AFp->fp, (long int) (offsb + is * LW), (void *) Buf,
		       (size_t) LW, (size_t) n);
    if (Nval != n)
      UThalt ("AFreadU1: Unexpected end-of-file");

    /* Convert to float */
    /* For offset-binary 8-bit data, the zero-point is the value 128 */
    for (i = 0; i < Nval; ++i) {
      ival = Buf[i];
      ival -= 128;
      Fbuff[is] = AFp->ScaleF * ival;
      ++is;
    }
  }

  return is;
}
