/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  nucleus.h

Description:
  Function prototypes for the TSP library internal (nucleus) routines

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.20 $  $Date: 1996/08/15 14:21:11 $

----------------------------------------------------------------------*/

#ifndef nucleus_h_
#define nucleus_h_

#include <stdio.h>	/* typedef for FILE */
			/* also size_t and NULL */
#include <time.h>	/* typedef for time_t */

#ifdef __STDC__
#  define p_(params)	params
#else
#  define const				/* Define const for K&R C */
#  define p_(params)	()
#endif

struct AF_NHpar;			/* Headerless audio file parameters */

#ifndef	AFILE_t_
#  define AFILE_t_
typedef struct AF_filepar AFILE;	/* Audio file parameters */
#endif

#ifdef __cplusplus
extern "C" {
#endif

/* ----- AF Prototypes ----- */
int
AFfileType p_((FILE *fp));
char *
AFgenHinfo p_((double Sfreq, int *Nchar));
struct AF_NHpar *
AFgetNH p_((void));
AFILE *
AFgetAIpar p_((FILE *fp, const char Fname[], long int *Nsamp,
	       long int *Nchan, float *Sfreq, FILE *fpout));
AFILE *
AFgetAUpar p_((FILE *fp, const char Fname[], long int *Nsamp,
	       long int *Nchan, float *Sfreq, FILE *fpout));
char *
AFgetAUrec p_((const char name[], const char head[], int N));
AFILE *
AFgetBLpar p_((FILE *fp, const char Fname[], long int *Nsamp,
	       long int *Nchan, float *Sfreq, FILE *fpout));
AFILE *
AFgetESpar p_((FILE *fp, const char Fname[], long int *Nsamp,
	       long int *Nchan, float *Sfreq, FILE *fpout));
AFILE *
AFgetINpar p_((FILE *fp, const char Fname[], long int *Nsamp,
	       long int *Nchan, float *Sfreq, FILE *fpout));
AFILE *
AFgetNHpar p_((FILE *fp, const char Fname[], long int *Nsamp,
	       long int *Nchan, float *Sfreq, FILE *fpout));
AFILE *
AFgetSFpar p_((FILE *fp, const char Fname[], long int *Nsamp,
	       long int *Nchan, float *Sfreq, FILE *fpout));
AFILE *
AFgetSPpar p_((FILE *fp, const char Fname[], long int *Nsamp,
	       long int *Nchan, float *Sfreq, FILE *fpout));
int
AFgetSPrec p_((const char name[], int type, void *data, int erropt,
	       const char head[], int N));
AFILE *
AFgetTApar p_((FILE *fp, const char Fname[], long int *Nsamp,
	       long int *Nchan, float *Sfreq, FILE *fpout));
AFILE *
AFgetWVpar p_((FILE *fp, const char Fname[], long int *Nsamp,
	       long int *Nchan, float *Sfreq, FILE *fpout));
void
AFprintAFh p_((AFILE *AFsp, const char Fname[], const char Datetime[],
	       double Sfreq, FILE *fpout));
int
AFreadAlaw p_((AFILE *AFp, long int offs, float Fbuff[], int Nreq));
int
AFreadF4 p_((AFILE *AFp, long int offs, float Fbuff[], int Nreq));
int
AFreadHead p_((FILE *fp, long int offs, void *buf, int size, int Nelem,
	       int Swapb));
int
AFreadI1 p_((AFILE *AFp, long int offs, float Fbuff[], int Nreq));
int
AFreadI2 p_((AFILE *AFp, long int offs, float Fbuff[], int Nreq));
int
AFreadMulaw p_((AFILE *AFp, long int offs, float Fbuff[], int Nreq));
int
AFreadTA p_((AFILE *AFp, long int offs, float Fbuff[], int Nreq));
int
AFreadU1 p_((AFILE *AFp, long int offs, float Fbuff[], int Nreq));
void
AFresHinfo p_((void));
AFILE *
AFsetAFp p_((FILE *fp, int Op, int Ftype, int Format, int Swapb,
	     double ScaleF, long int Nchan, long int Start, long int Ldata,
	     long int Nsamp));
AFILE *
AFsetAIpar p_((const char Fname[], int Format, long int Nchan, double Sfreq,
	       FILE *fpout));
AFILE *
AFsetAUpar p_((const char Fname[], int Format, long int Nchan, double Sfreq,
	       FILE *fpout));
AFILE *
AFsetNHpar p_((const char Fname[], int Format, long int Nchan, double Sfreq,
	       FILE *fpout));
AFILE *
AFsetWVpar p_((const char Fname[], int Format, long int Nchan, double Sfreq,
	       FILE *fpout));
void
AFupdAIhead p_((const AFILE *AFp));
void
AFupdAUhead p_((const AFILE *AFp));
void
AFupdWVhead p_((const AFILE *AFp));
void
AFwriteAlaw p_((AFILE *AFp, const float Fbuff[], int Nval));
void
AFwriteF4 p_((AFILE *AFp, const float Fbuff[], int Nval));
int
AFwriteHead p_((FILE *fp, long int offs, const void *buf, int size, int Nelem,
		int Swapb));
void
AFwriteI1 p_((AFILE *AFp, const float Fbuff[], int Nval));
void
AFwriteI2 p_((AFILE *AFp, const float Fbuff[], int Nval));
void
AFwriteMulaw p_((AFILE *AFp, const float Fbuff[], int Nval));
void
AFwriteTA p_((AFILE *AFp, const float Fbuff[], int Nval));
void
AFwriteU1 p_((AFILE *AFp, const float Fbuff[], int Nval));

/* ----- FI Prototypes ----- */
double
FIxKaiser p_((double x, double alpha));

/* ----- FL Prototypes ----- */
int
FLexist p_((const char Fname[]));
int
FLfReadTF p_((FILE *fp, int MaxNval, int cc, float x[]));
long int
FLfileSize p_((FILE *fp));
int
FLjoinNames p_((const char Dname[], const char Bname[], char Fname[]));
int
FLreadFile p_((FILE *fp, long int offs, void *ptr, size_t elem_size,
	       size_t count));
int
FLterm p_((FILE *fp));
void
FLwriteFile p_((FILE *fp, long int offs, const void *ptr, size_t elem_size,
		size_t count));

/* ----- ST Prototypes ----- */
int
STdec1val p_((const char String[], char Type, void *Val));
int
STdecNval p_((const char String[], int Nmin, int Nmax, char Type, void *Val,
	      int *N));
int
STdecPair p_((const char String[], const char Delim[], char Type,
	      void *Val1, void *Val2));
char *
STstrstrNM p_((const char Si[], const char Ti[], int N, int M));
char *
STtrimIws p_((const char Si[]));
int
STtrimNMax p_((const char Si[], char So[], int N, int Maxchar));

/* ----- UT Prototypes ----- */
int
UTbyteOrder p_((void));
int
UTcheckIEEE p_((void));
char *
UTctime p_((time_t *timer, int format));
double
UTdIEEE80 p_((const unsigned char b[10]));
int
UTdecOption p_((const char String[], const char Option[],
		const char **Arg));
void
UTeIEEE80 p_((double V, unsigned char b[10]));
char *
UTgetHost p_((void));
char *
UTgetUser p_((void));

/* ----- VR Prototypes ----- */
void
VRswapBytes p_((const void *BuffI, void *BuffO, size_t size, int Nelem));

#ifdef __cplusplus
}
#endif

#endif /* nucleus_h_ */
