/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  ESpar.h

Description:
  Declarations for ESPS sampled data feature file headers

Author / revision:
  P. Kabal  Copyright (C) 1995
  $Revision: 1.12 $  $Date: 1995/07/03 00:59:54 $

----------------------------------------------------------------------*/

#ifndef ESpar_h_
#define ESpar_h_

#include <libtsp/UTtypes.h>		/* typedef for uint4_t, etc */

#define	ES_LHMIN	((int) (sizeof (struct ES_preamb) + \
				sizeof (struct ES_head)))
#define	ES_MAXINFO	8192

/*  File magic value in file byte order.  ESPS files can be written in either
    big-endian or little-endian byte order.
*/
#define	FM_ESPS		"\0\0\152\32"
#define	FM_ESPS_SWAPPED	"\32\152\0\0"
#define ES_FTYPE	13

struct ES_preamb {
/*  uint4_t Machine_code; */	/* machine which wrote file */
/*  uint4_t Check_code;	*/	/* version check code */
  uint4_t Data_offset;		/* data offset in bytes */
  uint4_t Record_size;		/* record size */
  char Magic[4];		/* file magic */
/*  uint4_t Edr; */		/* EDR_ESPS flag */
/*  uint4_t Align_pad_size; */	/* alignment pad */
/*  int4_t Foreign_hd; */	/* pointer to foreign header */
};

struct ES_head {
  uint2_t Type;		/* File type (13) */
/*  uint2_t fill; */
  char Magic[4];	/* File magic */
  char Datetime[26];	/* File creation date */
  char Version[8];	/* Header version */
  char Prog[16];	/* Program name */
  char Vers[8];		/* Program version */
  char Progdate[26];	/* Program compile date */
  int4_t Ndrec;		/* Number of data records */
/*  uint4_t Tag; */
/*  uint4_t Ndouble; */
  uint4_t Nfloat;
/*  uint4_t Nlong; */
  uint4_t Nshort;
  uint4_t Nchar;
/*  uint4_t Fixsiz; */	/* Fixed header size (40) ?? */
/*  uint4_t Hsize; */	/* Variable header size ?? */
/*  char User[8]; */
			/* more unknown fields */
};

/* Structure for record frequency */
struct ES_recfreq {
  int2_t code1;		/* code1 = 3 */
  int2_t code2;		/* code2 = 3 */
  char c[12];		/* "record_freq" */
  int4_t count;		/* count = 1 */
  uint2_t data_code;	/* data_code = 1 (double) */
  double8_t sfreq;	/* sampling frequency */
};

#endif	/* ESpar_h_ */
