/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  AUpar.h

Description:
  Declarations for AFsp (Sun) audio file headers

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.22 $  $Date: 1996/09/04 21:50:18 $

----------------------------------------------------------------------*/

#ifndef AUpar_h_
#define AUpar_h_

#include <libtsp/UTtypes.h>		/* typedef for uint4_t */

/* The Sun header size is mandated to be at least 28 bytes long (the last 4
   bytes being comments).  However there are files extant which have only 24
   byte headers.
*/
#define AFsp_LHMIN	28
#define AU_LHMIN	24
#define	AFsp_LHMAX	10240
#define AFsp_MAXINFO	(AFsp_LHMAX - AFsp_LHMIN)

/* File magic values in file byte order */
#define	FM_SUN		"\056\163\156\144"	/* ".snd" */
#define FM_AFSP		"\101\106\163\160"	/* "AFsp" */

enum {
  AU_UNSPEC	= 0,	/* unspecified format */
  AU_MULAW8	= 1,	/* mu-law 8-bit data */
  AU_LIN8	= 2,	/* linear twos complement 8-bit data */
  AU_LIN16	= 3,	/* linear twos complement 16-bit data */
  AU_LIN24	= 4,	/* linear twos complement 24-bit data */
  AU_LIN32	= 5,	/* linear twos complement 32-bit data */
  AU_FLOAT32	= 6,	/* IEEE 32-bit float data (-1. to +1.) */
  AU_DOUBLE64	= 7,	/* IEEE 64-bit float data */
  AU_G721	= 23,	/* CCITT G.721 4-bit ADPCM */
  AU_G722	= 24,	/* CCITT G.722 */
  AU_G723_3	= 25,	/* CCITT G.723 3-bit ADPCM */
  AU_G723_5	= 26,	/* CCITT G.723 5-bit ADPCM */
  AU_ALAW8	= 27	/* A-law 8-bit data */
};

#define AU_SF_MULAW8	(1.)
#define AU_SF_ALAW8	(1.)
#define AU_SF_LIN8	(128.)
#define AU_SF_LIN16	(1.)
#define AU_SF_FLOAT32	(32768.)

#define	AU_NOSIZE	(~((uint4_t) 0))	/* Indeterminate data length */

struct AU_head {
  char Magic[4];	/* File magic */
  uint4_t Lhead;	/* Length of header in bytes */
  uint4_t Ldata;	/* Length of data portion in bytes */
  uint4_t Dencod;	/* Encoding type */
  uint4_t Srate;	/* Sampling rate */
  uint4_t Nchan;	/* Number of channels */
  char AFspID[4];	/* AFsp identifier */
};

#endif	/* AUpar_h_ */
