/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  AIpar.h

Description:
  Declarations for AIFF and AIFF-C audio file headers

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.8 $  $Date: 1996/09/04 21:49:57 $

----------------------------------------------------------------------*/

#ifndef AIpar_h_
#define AIpar_h_

#include <libtsp/UTtypes.h>		/* typedef for uint2_t, etc */

/* AIFF or AIFF-C file layout
  FORM chunk           8 + 4 + FVER/COMM/SSND chunks
  FVER chunk           8 + 4  (AIFF-C files only)
  COMM chunk           8 + 18 + compressionType (4 bytes)
                         + compressionName (min length 2)
  SSND chunk           8 + 8 + data

  AIFF files do not have the compressionType and compressionName fields in the
  COMM chunk.  The minimum length AIFF file is 54 bytes long; the minimum
  length AIFF-C file is 72 bytes long.
*/

#define AI_LHMIN	54

/* File magic in file byte order */
#define FM_IFF		"\106\117\122\115"	/* "FORM" */
#  define FM_AIFF	"\101\111\106\106"	/* "AIFF" */
#  define FM_AIFF_C	"\101\111\106\103"	/* "AIFC" */
#define CKID_COMM	"\103\117\115\115"	/* "COMM" */
#define CKID_FVER	"\106\126\105\122"	/* "FVER" */
#define CKID_SSND	"\123\123\116\104"	/* "SSND" */

#define CT_NONE		"\116\117\116\105"	/* "NONE" */
#define CT_ULAW		"\125\114\101\127"	/* "ULAW" */
#define CT_ALAW		"\101\114\101\127"	/* "ALAW" */

/* Pascal strings: length byte followed by string */
#define CN_NONE		"\016not compressed"
#define CN_ULAW		"\022ITU-T G.711 mu-law"
#define CN_ALAW		"\021ITU-T G.711 A-law"

#define AI_SF_ULAW	(1.)
#define AI_SF_ALAW	(1.)
#define AI_SF_NONE8	(128.)
#define AI_SF_NONE16	(1.)

#define AIFCVersion1	0xA2805140	/* AIFF-C Version 1 identifier */

struct AI_CkPreamb {
  char ckID[4];
  uint4_t ckDataSize;
};

struct AI_CkCOMM {
  uint2_t numChannels;
  uint4_t numSampleFrames;
  uint2_t sampleSize;
  unsigned char sampleRate[10];
  char compressionType[4];
  char compressionName[33];	/* Room for a 32 character string */
};

struct AI_CkFVER {
  uint4_t timestamp;
};

struct AI_CkSSND {
  uint4_t offset;
  uint4_t blockSize;
};

#endif	/* AIpar_h_ */
