/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  FiltAudio.h

Description:
  Declarations for ResampAudio

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.10 $  $Date: 1996/10/29 16:13:08 $

----------------------------------------------------------------------*/

#ifndef ResampAudio_h_
#define ResampAudio_h_

#define PROGRAM "ResampAudio"
#define VERSION	"v1r2a  1996/10/29"

#ifndef sun
#  include <float.h>
#else
#  include <values.h>
#  define DBL_MAX MAXDOUBLE
#endif

#define MAXCOF		8001		/* Max number coeffs from a file */
#define MAXIR		24

#include <libtsp.h>			/* typedef for AFILE */

#define IR_DEFAULT	0
#define DEL_DEFAULT	DBL_MAX
#define FC_DEFAULT	0.0
#define GAIN_DEFAULT	0.0
#define ALPHA_DEFAULT	(0.1102 * (80.0 - 8.7))	/* 80 dB */
#define NCOF_DEFAULT	0
#define WSPAN_DEFAULT	DBL_MAX
#define WOFFS_DEFAULT	DBL_MAX
#define BTN		0.15		/* Normalized transition width */

struct Fspec_T {
  char *FFile;		/* Input filter coefficient file name */
  char *WFile;		/* Output filter coefficient file name */
  int Ir;		/* Interpolation filter ratio */
  double Del;		/* Filter delay (samples) */
  double Fc;		/* Filter cutoff */
  double Gain;		/* Filter passband gain */
  double alpha;		/* Kaiser window parameter */
  int Ncof;		/* Number of filter coefficients */
  double Wspan;		/* Kaiser window span (samples) */
  double Woffs;		/* Kaier window offset (samples) */
};

struct Fpoly_T {
  float **hs;		/* Coefficients in subfilter order, hs[Ir+1][Ncmax] */
  int *offs;		/* Offset of first coefficient in each subfilter */
  int *Nc;		/* Number of coefficients in each subfilter */
  int Ncmax;		/* Maximum number of coefficients in any subfilter */
  int Ir;		/* Number of subfilters */
};
/*
  Note that there is an extra subfilter with the Ir'th one pointing to the
  zero'th one, but having a offset differing by 1.
*/

#ifdef __cplusplus
extern "C" {
#endif

/* Prototypes */
void
RSKaiserLPF p_((float h[], int N, double Fc, double alpha, double Gain,
		double Woffs, double Wspan));
double
RSKalphaXatt p_((double alpha));
double
RSKalphaXD p_((double alpha));
double
RSKattenXalpha p_((double atten));
void
RSexpTime p_((double t, double Ns, long int *n, double *ds, double *dsr));
void
RSfiltSpec p_((const char String[], struct Fspec_T *Fspec));
void
RSintFilt p_((double Sratio, double Soffs, const struct Fspec_T *Fspec,
	      struct Fpoly_T *PF, double *FDel));
void
RSinterp p_((const float x[], int Nxm, float y[], int Ny, double dsr,
	     double ds, double Ds, double Ns, const struct Fpoly_T *PF));
void
RSoptions p_((int argc, const char *argv[], int *Fformat, long int *Nout,
	      double *Soffs, double *Sratio, double *SfreqO,
	      struct Fspec_T *Fspec, const char **Hinfo, const char **NHparms,
	      const char *Fname[2]));
void
RSratio p_((double Sratio, int Ir, double *Ns, double *Ds, long int NsMax,
	    long int DsMax));
int
RSrefresh p_((AFILE *AFpI, long int offs, float x[], int Nx));
void
RSresamp p_((AFILE *AFpI, AFILE *AFpO, double Sratio, long int Nout,
	     double Soffs, const struct Fpoly_T *PF));
void
RSwriteCof p_((const char Fname[], const struct Fspec_T *Fs, const float h[]));

#ifdef __cplusplus
}
#endif

#endif /* ResampAudio_h_ */
