/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  GenNoise [options] AFile

Purpose:
  Generate an audio file containing uncorrelated Gaussian noise samples

Description:
  This program generates zero-mean uncorrelated pseudo-random Gaussian
  deviates.  These white noise samples are written to an audio file.  Each
  invocation of this program generates a different random sequence.  Options
  are available to specify the number of samples, the sampling frequency and
  the data format of the output file.

Options:
  The command line specifies options and the output file name.
  -l LENGTH, --length=LENGTH
      Number of samples in the output audio file.
  -d SDEV, --std_deviation=SDEV
      Standard deviation of the noise samples, default 1000.
  -x SEED, --seed=SEED
      Seed for the random number generator, default from current time.
  -s SFREQ, --srate=SFREQ
      Sampling frequency for the output audio file, default 8000.
  -D DFORMAT, --data_format=DFORMAT
      Data format for the output file, default integer16
        "mu-law8"   - 8-bit mu-law data
        "A-law8"    - 8-bit A-law data
        "unsigned8" - offset-binary 8-bit integer data
        "integer8"  - two's-complement 8-bit integer data
        "integer16" - two's-complement 16-bit integer data
        "float32"   - 32-bit IEEE floating-point data
        "text"      - text data
      The data formats available depend on the output file type.
      AFsp (Sun) audio files:
        mu-law, A-law, 8-bit integer, 16-bit integer, float
      RIFF WAVE files:
        mu-law, A-law, offset-binary 8-bit integer, 16-bit integer
      AIFF-C audio files:
        mu-law, A-law, 8-bit integer, 16-bit integer
      Headerless files:
        all data formats
  -F FTYPE, --file_type=FTYPE
      File type, default "AFsp".
        "AFsp", "Sun" or "sun"   - AFsp (Sun) audio file
        "WAVE" or "wave"         - RIFF WAVE file
        "AIFF-C" or "aiff-c"     - AIFF-C audio file
        "noheader_native"        - Headerless file (native byte order)
        "noheader_swap"          - Headerless file (byte swapped)
        "noheader_big-endian"    - Headerless file (big-endian byte order)
        "noheader_little-endian" - Headerless file (little-endian byte order)
  -I INFO, --info=INFO
      Header information string.
  -h, --help
      Print a list of options and exit.
  -v, --version
      Print the version number and exit.

  For AFsp output files, the audio file header contains an information string.
    Standard Header Information:
      date:1994/01/25 19:19:39 UTC    date
      user:kabal@aldebaran            user
      program:GenNoise                program name
  This information can be changed with the header information string which is
  specified as one of the command line options.  Structured information records
  should adhere to the above format with a named field terminated by a colon,
  followed by numeric data or text.  Comments can follow as unstructured
  information.  For the purpose of this program, records are terminated by
  newline characters.  However in the header itself, the newline characters are
  replaced by nulls.  To place a newline character into the header, escape
  the newline character by preceding it with a '\' character.  If the first
  character of the user supplied header information string is a newline
  character, the header information string is appended to the standard header
  information.  If not, the user supplied header information string replaces
  the standard header information.

Author / version:
  P. Kabal / v1r8  1996/10/29  Copyright (C) 1996

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: GenNoise.c 1.28 1996/10/29 AFsp-V2R2 $";

#include <stdio.h>		/* stdout */
#include <stdlib.h>
#include <libtsp.h>
#include <libtsp/AFpar.h>
#include "GenNoise.h"

#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS	0	/* Normally in stdlib.h */
#endif

#define MINV(a, b)	(((a) < (b)) ? (a) : (b))
#define MAXBUF	5120

int
main (argc, argv)

     int argc;
     const char *argv[];

{
  int Fformat;
  long int Nsamp;
  const char *Hinfo;
  const char *Fname;
  AFILE *AFp;
  int i, n;
  int seed;
  long int k;
  float Sfreq, rms;
  float x[MAXBUF];

/* Get the input parameters */
  GNoptions (argc, argv, &Fformat, &Sfreq, &rms, &seed, &Nsamp, &Hinfo,
	     &Fname);

/* Open the output file */
  Fformat = AOsetDFormat (Fformat, NULL, 0);
  if (Hinfo != NULL)
    AFsetHinfo (Hinfo);
  FLbackup (Fname);
  AFp = AFopenWrite (Fname, Fformat, 1L, (double) Sfreq, stdout);

/* Generate the noise samples */
  MSrandSeed (seed);
  k = 0;
  while (k < Nsamp) {
    n = (int) MINV (Nsamp - k, MAXBUF);
    for (i = 0; i < n; ++i)
      x[i] = MSfGaussRand ((double) rms);
    k += n;
    AFwriteData (AFp, x, n);
  }

/* Close the audio file */
  AFclose (AFp);

  return EXIT_SUCCESS;
}
