/*------------ Telecommunications & Signal Processing Lab --------------
                         McGill University

Routine:
  FiltAudio.h

Description:
  Declarations for FiltAudio

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.32 $  $Date: 1996/10/29 15:33:34 $

----------------------------------------------------------------------*/

#ifndef FiltAudio_h_
#define FiltAudio_h_

#define PROGRAM "FiltAudio"
#define VERSION	"v1r13  1996/10/29"

#define MAXCOF		4000

#include <libtsp.h>			/* typedef for AFILE */

#ifdef __cplusplus
extern "C" {
#endif

/* Prototypes */
void
FAfiltAP p_((AFILE *AFpI, AFILE *AFpO, long int NsampO, const float h[],
	     int Ncof, long int loffs));
void
FAfiltFIR p_((AFILE *AFpI, AFILE *AFpO, long int NsampO, const float h[],
	      int Ncof, long int loffs));
void
FAfiltIIR p_((AFILE *AFpI, AFILE *AFpO, long int NsampO, const float h[][5],
	      int Nsec, long int loffs));
void
FAfiltSI p_((AFILE *AFpI, AFILE *AFpO, long int NsampO, const float h[],
	     int Ncof, int Nsub, int Ir, long int moffs));
void
FAoptions p_((int argc, const char *argv[], int *Fformat, long int *Nout,
	      long int *idoffs, int *Nsub, int *Ir, const char **Hinfo,
	      const char **NHparms, const char *Fname[3]));

#ifdef __cplusplus
}
#endif

#endif /* FiltAudio_h_ */
