/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void CCcopySamp (AFILE *AFp, long int Lim[2], double Gain, AFILE *AFpO)

Purpose:
  Copy and scale audio file samples

Description:
  This copies samples from an input audio file to an output audio file.  The
  samples in the output file are scaled by a given gain.

Parameters:
   -> AFILE *AFpI
      Input file audio file pointer
   -> long int Lim[2]
      Two element array of sample limits
   -> double Gain
      Gain applied to the input samples
   -> AFILE *AFpO
      Output file audio file pointer

Author / revision:
  P. Kabal  Copyright (C) 1996
  $Revision: 1.3 $  $Date: 1996/06/01 02:46:27 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: CCcopySamp.c 1.3 1996/06/01 AFsp-V2R2 $";

#include <stdio.h>
#include <libtsp.h>
#include "ConcatAudio.h"

#define MINV(a, b)	(((a) < (b)) ? (a) : (b))

#define BFSIZE	5120

void
CCcopySamp (AFpI, Lim, Gain, AFpO)

     AFILE *AFpI;
     long int Lim[2];
     double Gain;
     AFILE *AFpO;

{
  float Fbuf[BFSIZE];
  long int offs;
  int Nsamp;

  offs = Lim[0];
  while (offs <= Lim[1]) {
    Nsamp = (int) MINV (Lim[1] - offs + 1, BFSIZE);
    AFreadData (AFpI, offs, Fbuf, Nsamp);
    VRfScale (Gain, Fbuf, Fbuf, Nsamp);
    AFwriteData (AFpO, Fbuf, Nsamp);
    offs = offs + Nsamp;
  }

  return;
}
