/* udpopen.c - udpopen */

#include <conf.h>
#include <kernel.h>
#include <i550.h>
#include <udp.h>

/*------------------------------------------------------------------------
 * udpopen  --  open a UDP port
 *------------------------------------------------------------------------
 */
udpopen(devptr, lport, raddr, qlen)
struct	devsw	*devptr;
int	lport;
char	*raddr;
int	qlen;
{
	struct	udpblk	*udpptr;
	int	ip, udp, rport;
	char	*p;
	
	for (p = raddr; *p != ':' && *p != '\0'; ++p)
		;
	if (*p != ':')
		return(SYSERR);
	*p++ = '\0';
	rport = 0;
	while (*p != '\0') {
		if (*p < '0' || '9' < *p)
			break;
		rport = 10 * rport + *p++ - '0';
	}
	if (*p != '\0')
		return(SYSERR);
	for (ip = 0; ip < sizeof(iptab)/sizeof(ipent); ++ip)
		if (strcmp(raddr, iptab[ip].name) == 0)
			break;
	if (ip >= sizeof(iptab)/sizeof(ipent))
		return(SYSERR);
	if ((udp = udpalloc()) == SYSERR)
		return(SYSERR);
	udpptr = &udptab[udp];
	udpptr->udp_lpnum = lport;
	udpptr->udp_rpnum = rport;
	bcopy(iptab[ip].ipaddr, udpptr->udp_ripaddr, IP_ADDR_SIZE);
	udpptr->udp_iport = pcreate(qlen);
	return(udp);
}
