/* udpalloc.c - udpalloc */

#include <conf.h>
#include <kernel.h>
#include <i550.h>
#include <udp.h>

/*------------------------------------------------------------------------
 * udpalloc  --  allocate a device table entry for a UDP device; return id
 *------------------------------------------------------------------------
 */
udpalloc()
{
	int	i;
	char	ps;
	
	disable(ps);
	for (i = 0; i < Nudp; ++i)
		if (udptab[i].udp_pid == 0) {
			udptab[i].udp_pid = getpid();
			restore(ps);
			return(i);
		}
	restore(ps);
	return(SYSERR);
}
