/* ttywrite.c - ttywrite, writcopy */

#include <conf.h>
#include <kernel.h>
#include <io.h>
#include <tty.h>

/*------------------------------------------------------------------------
 *  ttywrite - write one or more characters to a tty device
 *------------------------------------------------------------------------
 */
ttywrite(devptr, buff, count)
struct	devsw	*devptr;
char	*buff;
int	count;
{
   register struct tty *ttyp;
   struct	csr	*cptr;
   int avail;
   char ps;

   cptr = &((struct tty *)devptr->dvioblk)->csr;
   if (count < 0) return(SYSERR);
   if (count == 0) return(OK);
   disable(ps);
   ttyp = &tty[devptr->dvminor];
   if ( (avail=scount(ttyp->osem)) >= count) {
      writcopy(buff, ttyp, count);
      inton(cptr->ctmska,cptr->ctmask);
      if (ttyp->oidle == TRUE);
	ttyoin(ttyp);
   } else {
      if (avail > 0) {
	 writcopy(buff, ttyp, avail);
	 buff += avail;
	 count -= avail;
      }
      for (; count>0 ; count--) ttyputc(devptr, *buff++);
   }
   restore(ps);
   return(OK);
}

/*------------------------------------------------------------------------
 *  writcopy - high-speed copy from user's buffer into system buffer
 *------------------------------------------------------------------------
 */
LOCAL writcopy(buff, ttyp, count)
register char *buff;
struct	tty *ttyp;
int	count;
{
   register char	*qhead, *qend, *uend;

   qhead = &ttyp->obuff[ttyp->ohead];
   qend  = &ttyp->obuff[OBUFLEN];
   uend  = buff + count;
   while (buff < uend) {
      *qhead++ = *buff++;
      if ( qhead >= qend ) qhead = ttyp->obuff;
   }
   ttyp->ohead = qhead - ttyp->obuff;
   sreset(ttyp->osem, scount(ttyp->osem)-count);
}
