/* ttyputc.c - ttyputc */

#include <conf.h>
#include <kernel.h>
#include <io.h>
#include <tty.h>

/*------------------------------------------------------------------------
 *  ttyputc - write one character to a tty device
 *------------------------------------------------------------------------
 */
ttyputc(devptr, ch )
struct	devsw	*devptr;
char	ch;
{
   struct	tty   *iptr;
   struct	csr   *cptr;
   char		ps;

   iptr = &tty[devptr->dvminor];
   cptr = &iptr->csr;
   if ( ch==NEWLINE && iptr->ocrlf ) ttyputc(devptr,RETURN);

   wait(iptr->osem);		/* wait	for space in queue	*/
   disable(ps);
   iptr->obuff[iptr->ohead++] = ch;
   if (iptr->ohead	>= OBUFLEN) iptr->ohead = 0;

   inton(cptr->ctmska,cptr->ctmask); /* turn on Xmitter interrupts */
   if (iptr->oidle == TRUE)
	ttyoin(iptr);
   restore(ps);
   return(OK);
}
