/* ttyoin.c - ttyoin */

#include <conf.h>
#include <kernel.h>
#include <io.h>
#include <tty.h>

/*------------------------------------------------------------------------
 *  ttyoin  --  lower-half tty device driver for output interrupts
 *------------------------------------------------------------------------
 */
INTPROC	ttyoin(iptr)
register struct	tty   *iptr;
{
   register struct	csr	*cptr;
   int			ct;

#ifdef SLOWVAX
   /* this is against everything I believe in */
   for (ct=250; --ct;);
#endif
   iptr->oidle = TRUE;
   cptr = &iptr->csr;
   if (iptr->ehead != iptr->etail) {
      iptr->oidle = FALSE;
      outbyte(cptr->ctbuf,iptr->ebuff[iptr->etail++]);
      if (iptr->etail >= EBUFLEN) iptr->etail = 0;
      return;
   }
   if (iptr->oheld) {			/* honor flow control	*/
      intoff(cptr->ctmska,cptr->ctmask);
      return;
   }
   if ((ct=scount(iptr->osem)) < OBUFLEN) {
      iptr->oidle = FALSE;
      outbyte(cptr->ctbuf,iptr->obuff[iptr->otail++]);
      if (iptr->otail >= OBUFLEN)
      iptr->otail = 0;
      if (ct > OBMINSP) signal(iptr->osem);
      else if ( ++(iptr->odsend) == OBMINSP) {
	 iptr->odsend = 0;
	 signaln(iptr->osem, OBMINSP);
      }
      } else {
	 intoff(cptr->ctmska,cptr->ctmask);
      }
}
