/* ttyinit.c - ttyinit */

#include <conf.h>
#include <kernel.h>
#include <io.h>
#include <tty.h>

/*------------------------------------------------------------------------
 *  ttyinit - initialize buffers and modes for a tty line
 *------------------------------------------------------------------------
 */
ttyinit(devptr)
struct	devsw	*devptr;
{
register struct	tty *iptr;
register struct	csr *cptr;
int i, junk, isconsole;

   /* set up interrupt vector and interrupt dispatch table */

   iptr = &tty[devptr->dvminor];
   iosetvec(devptr->dvnum, iptr, iptr);
   devptr->dvioblk = (char *) iptr;		/* fill tty control blk	*/

   cptr = &iptr->csr;				/* fill in tty csr info */
   cptr->crstat = devptr->dvcsr;
   cptr->crbuf = devptr->dvcsr - 2;
   cptr->crmask = RXINTR;
   cptr->crmska = PICMASK;

   cptr->ctstat = devptr->dvcsr;
   cptr->ctbuf = devptr->dvcsr - 2;
   cptr->ctmask = TXINTR;
   cptr->ctmska = PICMASK;

   isconsole = (devptr->dvnum == CONSOLE);	/* make console cooked	*/
   iptr->ihead = iptr->itail = 0;		/* empty input queue	*/
   iptr->isem = screate(0);			/* chars. read so far=0	*/
   iptr->osem = screate(OBUFLEN);		/* buffer available=all	*/
   iptr->odsend = 0;				/* sends delayed so far	*/
   iptr->ohead = iptr->otail = 0;		/* output queue empty	*/
   iptr->ehead = iptr->etail = 0;		/* echo queue empty	*/
   iptr->imode = (isconsole ? IMCOOKED : IMRAW);
   iptr->iecho = iptr->evis = isconsole;	/* echo console input	*/
   iptr->ierase = iptr->ieback = isconsole;/* console honors erase	*/
   iptr->ierasec = BACKSP;			/*  using ^h		*/
   iptr->ecrlf = iptr->icrlf = isconsole;	/* map RETURN on input	*/
   iptr->ocrlf = iptr->oflow = isconsole;
   iptr->ikill = isconsole;			/* set line kill == @	*/
   iptr->ikillc = ATSIGN;
   iptr->oheld = FALSE;
   iptr->ostart = STRTCH;
   iptr->ostop = STOPCH;
   iptr->icursor = 0;
   iptr->ifullc = TFULLC;
   iptr->oidle = TRUE;

   junk = inbyte(cptr->ctbuf);		/* clear receiver */
   /* enable receiver interrupts and disable transmitter interrupts */
   /*outbyte(USCSR,USDIS);*/			/* shut off the USART */
   /*outbyte(PICMASK,(inbyte(PICMASK) & ~RXINTR) | TXINTR);*/
   intoff(cptr->ctmska,cptr->ctmask);
   inton(cptr->crmska,cptr->crmask);
   /*outbyte(USCSR,USEN);*/				/* kick USART */
}
