/* ttygetc.c - ttygetc */

#include <conf.h>
#include <kernel.h>
#include <io.h>
#include <tty.h>

/*------------------------------------------------------------------------
 *  ttygetc - read one character from a tty device
 *------------------------------------------------------------------------
 */
ttygetc(devptr)
struct	devsw	*devptr;
{
	char	ps;
	int	ch;
	struct	tty   *iptr;

	disable(ps);
	iptr = &tty[devptr->dvminor];
	wait(iptr->isem);		/* wait	for a character	in buff	*/
	ch = iptr->ibuff[iptr->itail++];
	if (iptr->itail	== IBUFLEN)
		iptr->itail = 0;
	restore(ps);
	return(ch);
}
