	.text
/*
*	sizmem.s - sizmem 
*/
	MAXADDR=0xF3FF 			/* maximum possible memory address*/
					/* set to f3ff to allow for i550*/
					/* shared memory		*/
	STEP=0x100			/* probe stride			*/
	PATTERN=0x56B7			/* arbitrary bit pattern	*/
/*
* ============================================================
* sizmem -- size memory, placing highest valid address in maxaddr
* ============================================================
*/


	.globl _sizmem
	.globl _maxaddr
_sizmem:
	push   bp
	mov    bp,sp
	push   si
	push   di
	pushf				/* save incoming flags register	*/
	cli				/* disable interrupts		*/
	mov	bx,#MAXADDR		/* set reg bx to highest 	*/
				        /* possible loc.		*/
	and	bx,#0xFFFE		/* want the address of the	*/
				        /*  highest WORD		*/
sizloop:
	mov	(bx),#PATTERN		/* write out pattern		*/
	cmp	(bx),#PATTERN		/* did write work?		*/
	je	found			/* yes -- found high memory loc	*/
	sub	bx,#STEP		/* no -- move to next lower address*/
	jmp	sizloop			/* try again			*/
found:
	mov	_maxaddr,bx		/* set to highest location	*/
	popf				/* restore flags (and interrupts)*/
	pop	di
	pop	si
	pop	bp
	ret
