	.text
/*
*  setclkr.s - setclkr 
*/

	CCTLWORD = 0x70			/* timer control word
					* counter #1 (153.6 kHZ),
					* read/load LSB first, then MSB
					* mode 0 (interrupt on terminal count),
					* binary counter
					*/

	CCOUNT  = 15360			/* 100 millisecond delay between ticks
					* (corresponds to tick rate of 10 Hz)
					*/

	CCTLPORT=0x0D6			/* I/O address for writing the timer
					* mode control word
					*/

	CT1PORT=0x0D2			/* I/O address for loading timer 1's 
					* count value
					*/
/*
* ============================================================
*  setclkr -- initialize real-time clock and set clkruns to 1
* ============================================================
*/
	.globl	_setclkr
	.globl	_clkruns		/* declared in initialize.c	*/
_setclkr:
	push	si
	push	di
	movb	al,CCTLWORD		/* timer one control word	*/
	out	CCTLPORT		/* load control word		*/
	mov	cx,#CCOUNT		/* reload timer one count	*/
	movb	al,cl
	out	CT1PORT			/* load LSB			*/
 	movb	al,ch
	out	CT1PORT			/* then load MSB		*/
	mov	_clkruns,#1		/* initialize for clock exists	*/
	pop    di
	pop    si
	ret
