/* rsndmsg.c - rsndmsg */

#include <conf.h>
#include <kernel.h>
#include <fserver.h>
#include <rfile.h>

/*------------------------------------------------------------------------
 *  rsndmsg  --  send message to remote server and get reply
 *------------------------------------------------------------------------
 */
#ifdef	Nrf
rsndmsg(fptr)
struct	fpacket	*fptr;
{
	int	trys;
	int	ret;

	/* exclude for access to server, clear waiting datagrams, */
	/*  and try sending the command				  */
	wait(rfmutex);
	control(rfserver, RFCLEAR);
	for (trys=0 ; trys<RMAXTRY ; trys++) {
		if (write(rfserver,fptr,sizeof(struct fpakhdr))==SYSERR) {
			signal(rfmutex);
			return(SYSERR);
		}
		if ( (ret=read(rfserver,fptr,sizeof(struct fpacket)))
		    !=SYSERR) {
			signal(rfmutex);
			return(OK);
		}
	}
	signal(rfmutex);
	return(SYSERR);
}
#endif
