/* rfwrite.c - rfwrite */

#include <conf.h>
#include <kernel.h>
#include <fserver.h>
#include <rfile.h>

/*------------------------------------------------------------------------
 *  rfwrite  --  write one or more bytes to a remote file
 *------------------------------------------------------------------------
 */
#ifdef	Nrf
rfwrite(devptr, buff, len)
struct	devsw	*devptr;
char	*buff;
int	len;
{
	struct	rfblk	*rfptr;
	int	i;
	char	*buflim;
	struct	fpacket	packet;
	struct	fpakhdr	*fptr;

	rfptr = (struct rfblk *)devptr->dvioblk;
	wait(rfptr->rf_mutex);
	if (len < 0 || rfptr->rf_state == RFREE) {
		signal(rfptr->rf_mutex);
		return(SYSERR);
	}
	fptr = (struct fpakhdr *) &packet;
	fptr->f_op = SWRITE;
	strncpy(fptr->f_name, rfptr->rf_name, RNAMLEN);
	fptr->f_pos = rfptr->rf_pos;
	fptr->f_count = len;
	if (rsndmsg(fptr) == SYSERR)
		len = SYSERR;
	signal(rfptr->rf_mutex);
	return(len);
}
#endif
