/* rfread.c - rfread */

#include <conf.h>
#include <kernel.h>
#include <fserver.h>
#include <rfile.h>

/*------------------------------------------------------------------------
 *  rfread  --  read one or more bytes from a remote file
 *------------------------------------------------------------------------
 */
#ifdef	Nrf
rfread(devptr, buff, len)
struct	devsw	*devptr;
char	*buff;
int	len;
{
	struct	rfblk	*rfptr;
	struct	fpacket	packet;
	struct	fpakhdr	*fptr;
	int	retcode;
	int	length;
	char	*p;

	rfptr = (struct rfblk *)devptr->dvioblk;
	wait(rfptr->rf_mutex);
	if (len < 0 || rfptr->rf_state == RFREE) {
		signal(rfptr->rf_mutex);
		return(SYSERR);
	}
	fptr = (struct fpakhdr *) &packet;
	fptr->f_op = SREAD;
	fptr->f_pos = rfptr->rf_pos;
	strncpy(fptr->f_name, rfptr->rf_name, RNAMLEN);
	fptr->f_count = (long) len;
	if (rsndmsg(fptr) == SYSERR ||
	    fptr->f_op == SERROR) {
		signal(rfptr->rf_mutex);
		return(SYSERR);
	}
	rfptr->rf_pos = fptr->f_pos;
	p = packet.fp_data;
	for (len=0 ; len<fptr->f_count ; len++)
		*buff++ = *p++;
	signal(rfptr->rf_mutex);
	return(fptr->f_count);
}
#endif
