/* rfopen.c - rfopen */

#include <conf.h>
#include <kernel.h>
#include <fserver.h>
#include <rfile.h>

/*------------------------------------------------------------------------
 *  rfopen  --  open a connection to a file on the remote server
 *------------------------------------------------------------------------
 */
#ifdef	Nrf
rfopen(devptr, filenam, mode)
struct	devsw	*devptr;
char	*filenam;
char	*mode;
{
	struct	rfblk	*rfptr;
	int	mbits, rfindex;
	int	retcode;
	char	ps;

	disable(ps);
	if ( strlen(filenam) >= RNAMLEN     ||
	     (mbits=flckmd(mode)) == SYSERR ||
	     rsvopen() == SYSERR            ||
	     (rfindex=rfalloc()) == SYSERR)
		retcode = SYSERR;
	else {
		rfptr = &rftab[rfindex];
		strncpy(rfptr->rf_name, filenam, RNAMLEN);
		rfptr->rf_mode = mbits;
		rfptr->rf_pos = 0L;
		retcode = rfptr->rf_id;
	}
	restore(ps);
	return(retcode);
}
#endif
