/* rfclose.c - rfclose */

#include <conf.h>
#include <kernel.h>
#include <fserver.h>
#include <rfile.h>

/*------------------------------------------------------------------------
 *  rfclose  --  close a remote file by flushing buffers and deallocating
 *------------------------------------------------------------------------
 */
#ifdef	Nrf
rfclose(devptr)
struct	devsw	*devptr;
{
	struct	rfblk	*rfptr;

	rfptr = (struct rfblk *)devptr->dvioblk;
	wait(rfptr->rf_mutex);
	if (rfptr->rf_state == RFREE) {
		signal(rfptr->rf_mutex);
		return(SYSERR);
	}
/* MAKE UP CLOSE PACKET AND SEND*/
	rfptr->rf_state = RFREE;
	signal(rfptr->rf_mutex);
	return(OK);
}
#endif
