/* pcreate.c - pcreate */

#include <conf.h>
#include <kernel.h>
#include <mark.h>
#include <ports.h>

/*------------------------------------------------------------------------
 *  pcreate  --  create a port that allows "count" outstanding messages
 *------------------------------------------------------------------------
 */
SYSCALL	pcreate(count)
int	count;
{
	char	ps;
	int	i, p;
	struct	pt	*ptptr;
        static  int initialized = 0;     /*  flag to signal whether ports */
                                         /*  have been initialized.       */

	if (count < 0)
		return(SYSERR);
	disable(ps);

        if ( initialized == 0 )         /*  first call to pcreate, must  */
           {                            /*  call pinit to initialize     */
             initialized = 1;
             pinit ( MAXMSGS );
           }

#ifdef	MEMMARK
	if (mark(ptmark) == OK)
		pinit(MAXMSGS);
#endif
	for (i=0 ; i<NPORTS ; i++) {
		if ( (p=ptnextp--) <= 0)
			ptnextp = NPORTS - 1;
		if ( (ptptr= &ports[p])->ptstate == PTFREE) {
			ptptr->ptstate = PTALLOC;
			ptptr->ptssem = screate(count);
			ptptr->ptrsem = screate(0);
			ptptr->pthead = ptptr->pttail = NULL;
			ptptr->ptseq++;
			ptptr->ptmaxcnt = count;
			restore(ps);
			return(p);
		}
	}
	restore(ps);
	return(SYSERR);
}
