	.text
	.globl	_panic
	.globl	panic
	.globl	_kernstk
/*
*  _panic  --  entry point when called by user programs
*	ARG(1) = address of string containing panic message
*	stack upon entry to _panic is of the form
*		%sp+2:		&string
*		%sp:		old %ip (of process calling _panic)
*/
	ClrTF= 0xfeff
_panic:
	pushf				/* push flag register		*/
	cli				/* disable interrupts		*/
	pushf
	mov	axtemp,ax		/* save ax			*/
	mov	bptemp,bp
	pop	ax
	and	ax,#ClrTF
	push	ax
	popf				/* clear trap flag TF		*/
	mov	bp,sp
	mov	ax,*4(bp)		/* save address of users 	*/
	mov	pmsglist,ax		/*    panic message in pmaguser */
	pop	ax			/* move flag register		*/
	mov	*4(bp),ax		/*    to proper place on stack	*/
	pop	ax
	push	cs
	push	ax
	push	axtemp
	movb	al,*0			/* put type user panic		*/
	mov	bp,bptemp
/*
*  panic  -- entry point for traps and exceptions only; not called
*  stack frame is of the form
*  	sp+6:		old flag register(of interrupted process)
*	sp+4:		old cs
*	sp+2:		old ip
*	sp:		old ax
*  al contains type of interrupt
*/
panic:
	mov	sptemp,sp		/* sp when interrupt occurred	*/
	add	sptemp,*8
	xorb	ah,ah
	mov	itype,ax
	pop	ax
	mov	sp,#_kernstk		/* point sp to _kernstk		*/
	push	ss			/* push on kernel stack ss	*/
	push	es			/* push on kernel stack es	*/
	push	ds			/* push on kernel stack ds	*/
	push	*-4(bp)			/* push on kernel stack cs	*/
	push	di			/* push on kernel stack di	*/
	push	si			/* push on kernel stack si	*/
	push	sptemp			/* push on kernel stack sp	*/
	push	bp			/* push on kernel stack old bp	*/
	push	dx			/* push on kernel stack old dx	*/
	push	cx			/* push on kernel stack old cx	*/
	push	bx			/* push on kernel stack old bx	*/
	push	ax			/* push on kernel stack old ax	*/
	mov	bp,sptemp
	push	*-2(bp)
	push	*-6(bp)
	mov	bx,itype
	cmp    bx,*0
	bne    1$
	mov    bx,#pmsg0
	jmp    10$
1$:	cmp    bx,*1
	bne    2$
	mov    bx,#pmsg1
	jmp    10$
2$:	cmp    bx,*2
	bne    3$
	mov    bx,#pmsg2
	jmp    10$
3$:	cmp    bx,*3
	bne    4$
	mov    bx,#pmsg3
	jmp    10$
4$:	cmp    bx,*4
	bne    5$
	mov    bx,#pmsg4
5$:     cmp    bx,*5
	bne    6$
	mov    bx,#pmsg5
	jmp    10$
6$:     mov    bx,#pmsg5
10$:	push   bx
	mov	ax,#panmsg1
	push	ax
	call	_sizmem		/* size up memory (needed later)	*/
/*
* set up call to kprintf to print register and stack dump
*/
	call	_kprintf		/* print message			*/
	add	sp,*26		/* pop off args to printf, leaving	*/
				/*   saved regs, even though printed	*/

/*
* dump stack as long as sp was valid
*/
	mov	bp,sp
	mov	bx,sp
	mov	(bx),#panmsg2
	mov	bx,sptemp
	mov	cx,*6			/* # of stack items to print	*/
panloop:
/*	cmp	bx,_maxaddr		* avoid	references beyond valid */
	mov	ax,(bx)			/* insert stack word		*/
	mov	*2(bp),ax		/* to printf as argument	*/
	mov	tmpbx,bx
	mov	tmpcx,cx
	call	_kprintf		/* print one value		*/
	mov	bx,tmpbx
	mov	cx,tmpcx
	dec	cx			/* decrement # to print		*/
	jbe	pandone			/* stop if enough has been printed*/
	add	bx,*2			/* otherwise move along stack	*/
	jmp	panloop
pandone:
	int				/* user has to reset i8086	*/

	.data
tmpbx:     .word        0
tmpcx:     .word        0
axtemp:	   .word	0
sptemp:	   .word	0
bptemp:	   .word	0
tptemp:	   .word	0
itype:	   .word	0
panmsg1:
	.byte	10,10,80,97,110,105,99
	.byte	32,58,32
	.byte	37,115,10			/* '%s\n'	*/
	.byte	37,37,105,112,61,37		/* '%%ip=%'	*/
	.byte	48,52,120,32			/* '04x '	*/
	.byte	37,37,112,115,61,37		/* '%%ps=%'	*/
	.byte	48,52,120,32			/* '04x '	*/
	.byte	10				/* '\n'		*/
	.byte	37,37,97,120,61,37		/* '%%ax=%'	*/
	.byte	48,52,120,32			/* '04x '	*/
	.byte	37,37,98,120,61,37		/* '%%bx=%'	*/
	.byte	48,52,120,32			/* '04x '	*/
	.byte	37,37,99,120,61,37		/* '%%cx=%'	*/
	.byte	48,52,120,32			/* '04x '	*/
	.byte	37,37,100,120,61,37		/* '%%dx=%'	*/
	.byte	48,52,120,32			/* '04x '	*/
	.byte	10				/* '\n'		*/
	.byte	37,37,98,112,61,37		/* '%%bp=%'	*/
	.byte	48,52,120,32			/* '04x '	*/
	.byte	37,37,115,112,61,37		/* '%%sp=%'	*/
	.byte	48,52,120,32			/* '04x '	*/
	.byte	37,37,115,105,61,37		/* '%%si=%'	*/
	.byte	48,52,120,32			/* '04x '	*/
	.byte	37,37,100,105,61,37		/* '%%di=%'	*/
	.byte	48,52,120,32			/* '04x '	*/
	.byte	10				/* '\n'		*/
	.byte	37,37,99,115,61,37		/* '%%cs=%'	*/
	.byte	48,52,120,32			/* '04x '	*/
	.byte	37,37,100,115,61,37		/* '%%ds=%'	*/
	.byte	48,52,120,32			/* '04x '	*/
	.byte	37,37,101,115,61,37		/* '%%ss=%'	*/
	.byte	48,52,120,32			/* '04x '	*/
	.byte	37,37,115,115,61,37		/* '%%es=%'	*/
	.byte	48,52,120,32			/* '04x '	*/
	.byte	10,0				/* '\n\0'	*/
panmsg2:
	.byte	37,48,52,120,10,0		/*  */
	.even
pmsglist:
	.word	pmsg0,pmsg1,pmsg2,pmsg3,pmsg4,pmsg5
pmsg0:						/* Divide by zero  */
	.byte	68,105,118,105,100,101,32,98
	.byte	121,32,122,101,114,111,0
pmsg1:						/* Single step	 */
	.byte	83,105,110,103,108,101,32,115
	.byte	116,101,112,0
pmsg2:						/* Non-maskable interupt */
	.byte	78,111,110,45,109,97,115,107
	.byte	97,98,108,101,32,105,110,116
	.byte	101,114,114,117,112,116,0
pmsg3:						/* One byte interrupt */
	.byte	79,110,101,32,98,121,116,101
	.byte	32,105,110,116,101,114,114,117
	.byte	112,116,0
pmsg4:						/* Interrupt on Overflow */
	.byte	73,110,116,101,114,114,117,112
	.byte	116,32,111,110,32,111,118,101
	.byte	114,102,108,111,119,0
pmsg5:						/* Unknown device */
	.byte	85,110,107,110,111,119,110,32
	.byte	100,101,118,105,99,101,0
	.even
/* Stack used by kernel at startup and to handle panic messages.	*/

.	=	.+300			/* decimal bytes in kernel stack*/
_kernstk:
.	=	.+2			/* Otherwise kernstk overlaps	*/
					/* next symbol			*/
