/* mdump.c - mdump, mdumph */

#include <kernel.h>
#include <mem.h>

/*------------------------------------------------------------------------
 *  mdump  --  dump free memory list
 *------------------------------------------------------------------------
 */
mdump()
{
	char	ps;
	struct	mblock	*mptr;

	disable(ps);
	kprintf("Dump of free memory block list:\n");
	for( mptr=memlist.mnext ; mptr!=NULL ; mptr=mptr->mnext)
		kprintf("  block at %o, length %u (0%o)\n",
			mptr,mptr->mlen, mptr->mlen);
	restore(ps);
}

/*------------------------------------------------------------------------
 *  mdumph  --  dump free memory list and halt
 *------------------------------------------------------------------------
 */
mdumph()
{
	char	ps;
	struct	mblock	*mptr;

	disable(ps);
	kprintf("Dump of free memory block list:\n");
	for( mptr=memlist.mnext ; mptr!=NULL ; mptr=mptr->mnext)
		kprintf("  block at %o, length %u (0%o)\n",
			mptr,mptr->mlen, mptr->mlen);
	halt();
	restore(ps);
}
