#include <conf.h>
#include <kernel.h>
#include <io.h>
#include <tty.h>

#define USDAT	0xd8	/* port address of USART data register */
#define USCSR	0xda	/* port address of USART control status register */
#define USTXRDY	0x01	/* csr bit indication status of transmitter */

/*------------------------------------------------------------------------
 *  kprintf  --  kernel printf: formatted, unbuffered output to CONSOLE
 *------------------------------------------------------------------------
 */
kprintf(fmt, args)		/* Derived by Bob Brown, Purdue U.	*/
char *fmt;
{
   int     kputc();

   savestate();
   _doprnt(fmt, &args, kputc, CONSOLE);
   rststate();
   return(OK);
}

/*------------------------------------------------------------------------
 *  kputc  --  write a character on the console using polled I/O
 *------------------------------------------------------------------------
 */
LOCAL kputc(device ,c)
int device;
char c; /* character to print from _doprnt	*/
{
   unsigned int sport,dport;
   int slowdown;	/* added to delay output because VAX	*/
			/* can't take it at 9600 baud		*/
   if ( c == 0 ) return;
   if ( c == NEWLINE ) kputc( device, RETURN );

   siopoll(USCSR,USTXRDY);
   outbyte(USDAT,c);
   for(slowdown=500;slowdown--;);
   siopoll(USCSR,USTXRDY);
}

LOCAL int	siostat;
LOCAL char	saveps;
/*------------------------------------------------------------------------
 *  savestate  --  save the console control and status register
 *------------------------------------------------------------------------
 */
LOCAL savestate()
{
   char ps;

   disable(ps);
   saveps = ps;
}

/*------------------------------------------------------------------------
 *  rststate  --  restore the console output control and status register
 *------------------------------------------------------------------------
 */
LOCAL rststate()
{
   char ps;

   ps = saveps;
   restore(ps);
}
siopoll(sport,bits)
/* poll the given status port until the specified bits bits are set */
int sport,bits;
{
   while((inbyte(sport) & bits) != bits);
}
