#include <io.h>
#include <kernel.h>
#include <conf.h>
#include <i550.h>

struct arp_reply {
    struct edl_hdr edl_hdr;
    short	exm_length;
    short	exm_extnsn;
    char	exm_idsId;
    char	exm_ext2;
    short	exm_extLength;
    char	exm_dstAddr[ETHER_ADDR_SIZE];
    char	exm_srcAddr[ETHER_ADDR_SIZE];
    short	exm_type;
    struct arp_pkt arp_pkt;
};
char bcast[] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff}; 

ip_ether(pip_addr, pet_addr)
char *pip_addr, *pet_addr;
{

    struct arp_pkt  *parp_pkt;
    struct edl_sbuf *psbuf;
    struct edl_xmit *pxmit;

    wait(mutex_arp);
    pxmit = (struct edl_xmit *) control(ETHER, GET_XMIT_BUF );
/*    kprintf("ip_ether: got buf %x\n", pxmit); */
    parp_pkt = (struct arp_pkt *) &(pxmit -> exm_message[0]);
    bcopy(i550.et_addr, parp_pkt->arp_sha, ETHER_ADDR_SIZE);
    bcopy(i550.ip_addr, parp_pkt->arp_spa, IP_ADDR_SIZE);
    bcopy(pip_addr, parp_pkt->arp_tpa, IP_ADDR_SIZE);
    parp_pkt->arp_op = swapb(ARP_REQUEST);
    parp_pkt->arp_hln = 6;
    parp_pkt->arp_pln = 4;
    parp_pkt->arp_hrd = swapb(ARPHRD_ETHER);
    parp_pkt->arp_pro = swapb(ETHER_IPTYPE);
    bcopy(bcast, pxmit->exm_dstAddr, ETHER_ADDR_SIZE);
    pxmit->exm_type = swapb(ETHER_ARPTYPE);

/*    kprintf("ready to write to ether\n");
    sleep(5); */

/*    write(ETHER, pxmit, 42) ; */
      write(ETHER,pxmit,200);

	if ((psbuf=(struct edl_sbuf *) preceive(arp_port)) == SYSERR)
	    kprintf("ip_ether: couldn't do preceive\n");

	/* I now have the arp reply. */
    parp_pkt = (struct arp_pkt *) psbuf -> esb_message;
    if (strncmp(pip_addr, parp_pkt->arp_spa, IP_ADDR_SIZE) == 0){
	bcopy(parp_pkt->arp_sha, pet_addr, ETHER_ADDR_SIZE);
	control(ETHER, EDL_SUPPLYBUF, psbuf);
	signal(mutex_arp);
	return(TRUE);
    } else {
	kprintf("ip_ether: wanted %d.%d.%d.%d, got %d.%d.%d.%d\n",
	(short) pip_addr[0], (short) pip_addr[1], (short) pip_addr[2],
	(short) pip_addr[3], parp_pkt -> arp_spa[0],
	parp_pkt -> arp_spa[1], parp_pkt -> arp_spa[2],
	parp_pkt -> arp_spa[3]);
	control(ETHER, EDL_SUPPLYBUF, psbuf);
        signal(mutex_arp);
	return(FALSE);
    }
}
