/*
*  Upon entry to ioint, the interrupt sequence has been done twice,
*  and the stack looks like this:
*	flags
*	CS
*	PC (of point that was interrupted)
*	flags
*	CS
*	PC (of instruction after inttab entry)
*/
	.text
	.globl	_ioint
	.globl	_inttab
	.globl	_intmap
_ioint:				/* Code common to input & output	*/
	push	ax		/* Get saved PC in BX register		*/
	push	bx
	mov	bx,sp
	mov	bx,*4(bx)
	push	dx		/* Save registers not saved by C	*/
	push	si
	push	ds
	push	es

	sub	bx,#_inttab+2	/* Find offset within inttab of saved PC */
	shl	bx,*1		/* Convert to offset within intmap	*/
	add	bx,#_intmap	/* Form pointer to intmap entry		*/
	mov	si,(bx)		/* Get address of interrupt procedure	*/
	mov     ax,*2(bx)	/* Call interrupt routine with argument	*/
	push    ax
/*
* the following is a hack because I can't get the assembler
* to generate the correct code for "call (si)" 
* NOTE: this code is wrong (ie. xff = jmp) but this is what b16 generated
* and it seemed to work.
*/
	.byte  0xff
	.byte  0xd6
	add     sp,*2
	pop	es		/* Restore registers from stack		*/
	pop	ds
	pop	si
	pop	dx
	pop	bx
	pop	ax
	add	sp,*6		/* Pop PC, CS, and flags from 2nd int. seq.*/
	iret			/* Return from interrupt		*/
