#include <kernel.h>

/*#define	ICW1	0x1f	/* level trig; addr intrvl 4; single pic; icw4 needed */
#define	ICW1	0x17	/* edge trig; addr intrvl 4; single pic; icw4 needed */
#define	ICW2	0x20	/* interrupt vectors start at 0x80 */
#define	ICW4	0x0f	/* buffered; master; auto eoi; 8086 mode */

/* define the PIC port locations */

#define	PICCSR1	0xc0
#define	PICCSR2	0xc2


initpic(imask)

/* initialize the 8259 PIC to run in fully nested buffered mode
   with automatic end of interrupt.  The initial interrupt mask
   is set to imask
*/
int imask;
{
   char ps;
   disable(ps);
   /* output the three initialization control words */
   outbyte(PICCSR1,ICW1);
   outbyte(PICCSR2,ICW2);
   outbyte(PICCSR2,ICW4);
   /* set the initial mask */
   outbyte(PICCSR2,imask);
   restore(ps);
   return(inbyte(PICCSR2));
}
