/* initialize.c - nulluser, sysinit */

#include <conf.h>
#include <kernel.h>
#include <proc.h>
#include <sem.h>
#include <mem.h>
#include <io.h>
#include <tty.h>
#include <q.h>
#include <disk.h>

extern	int	main();			/* address of user's main prog	*/
int INIT();				/* address of system initialization
				        /* process			*/
/* Declarations of major kernel variables */

struct	pentry	proctab[NPROC]; /* process table			*/
int	nextproc;		/* next process slot to use in create	*/
struct	sentry	semaph[NSEM];	/* semaphore table			*/
int	nextsem;		/* next semaphore slot to use in screate*/
struct	qent	q[NQENT];	/* q table (see queue.c)		*/
int	nextqueue;		/* next slot in q structure to use	*/
int	*maxaddr;		/* max memory address (set by sizmem)	*/
#ifdef	NDEVS
struct	intmap	intmap[NDEVS];	/* interrupt dispatch table		*/
struct	intent	inttab[NDEVS];	/* fake interrupt vectors (for INTEL)	*/
#endif
struct	mblock	memlist;	/* list of free memory blocks		*/
#ifdef	Ntty
struct  tty     tty[Ntty];	/* SLU buffers and mode control		*/
#endif

/* active system status */

int	numproc;		/* number of live user processes	*/
int	currpid;		/* id of currently running process	*/
int	reboot = 0;		/* non-zero after first boot		*/

/* real-time clock variables and sleeping process queue pointers	*/

#ifdef	RTCLOCK
int     defclk = 0;		/* non-zero, then deferring clock count */
int     clkdiff = 0;		/* deferred clock ticks			*/
int     slnempty = FALSE;	/* FALSE if the sleep queue is empty	*/
int     *sltop;			/* address of key part of top entry in	*/
				/* the sleep queue if slnonempty==TRUE	*/
int     clockq;			/* head of queue of sleeping processes  */
int	preempt;		/* preemption counter.	Current process */
				/* is preempted when it reaches zero;	*/
				/* set in resched; counts in ticks	*/
int	clkruns;		/* set TRUE iff clock exists by setclkr	*/
#else
int	clkruns = FALSE;	/* no clock configured; be sure sleep	*/
#endif				/*   doesn't wait forever		*/
int	rdyhead,rdytail;	/* head/tail of ready list (q indexes)	*/


/************************************************************************/
/***				NOTE:				      ***/
/***								      ***/
/***   This is where the system begins after the C environment has    ***/
/***   been established.  Interrupts are initially DISABLED, and      ***/
/***   must eventually be enabled explicitly.  This routine turns     ***/
/***   itself into the null process after initialization.  Because    ***/
/***   the null process must always remain ready to run, it cannot    ***/
/***   execute code that might cause it to be suspended, wait for a   ***/
/***   semaphore, or put to sleep, or exit.  In particular, it must   ***/
/***   not do I/O unless it uses kprintf for polled output.           ***/
/***								      ***/
/************************************************************************/

/*------------------------------------------------------------------------
 *  nulluser  -- initialize system and become the null process (id==0)
 *------------------------------------------------------------------------
 */
nulluser()				/* babysit CPU when no one home */
{
	char	ps;
	long	memsize;

	kprintf("\n\nXinu Version %s", VERSION);
	if (reboot++ < 1)
		kprintf("\n");
	else
		kprintf("   (reboot %d)\n", reboot);
	sysinit();			/* initialize all of Xinu */
	memsize = (unsigned)maxaddr;
	memsize += (unsigned)sizeof(int);
	kprintf("%lu real mem\n", memsize);
	memsize = (unsigned)maxaddr + (unsigned)sizeof(int) - (unsigned)(&end);
	kprintf("%lu avail mem\n", memsize);
	kprintf("clock %sabled\n\n", clkruns==1?"en":"dis");
	enable();			/* enable interrupts */

	/* start a process that completes system initialization		*/

#ifdef ETHER
	resume(
	  create(INIT,INITSTK+200,INITPRIO,INITNAME,1,0)
	);
#else
	resume(
	  create(main,INITSTK+200,INITPRIO,INITNAME,1,0)
	  );
#endif
	while (TRUE) {			/* run forever without actually */
		pause();		/*  executing instructions	*/
	}
}

/*------------------------------------------------------------------------
 *  sysinit  --  initialize all Xinu data structures and devices
 *------------------------------------------------------------------------
 */
LOCAL	sysinit()
{
	int	i,j;
	struct	pentry	*pptr;
	struct	sentry	*sptr;
	struct	mblock	*mptr;
	struct	vector	*vptr;


	initpic( ~NOINTR );		/* initialize interrupt controller
					   chip to disable all interrupts */
	lowcore();			/* initialize interrupt vectors   */ 
	vptr = (struct vector *) INTVEC;
	vptr->vproc = (char *) INTDISP;
	vptr->vcs = INTCSR;

	numproc = 0;			/* initialize system variables    */
	nextproc = NPROC-1;
	nextsem = NSEM-1;
	nextqueue = NPROC;		/* q[0..NPROC-1] are processes */

	memlist.mnext = mptr =		/* initialize free memory list */
	  (struct mblock *) roundew(&end);
	mptr->mnext = (struct mblock *)NULL;
	mptr->mlen = (unsigned)truncew( (unsigned)maxaddr - NULLSTK -
		     			(unsigned)(&end) );
	for (i=0 ; i<NPROC ; i++)	/* initialize process table */
		proctab[i].pstate = PRFREE;

	pptr = &proctab[NULLPROC];	/* initialize null process entry */
	pptr->pstate = PRCURR;
	pptr->pprio = 0;
	for (i=0; i<PNREGS; i++)
		pptr->pregs[i] = 0;
	pptr->psem = 0;
	pptr->pmsg = 0;
	pptr->phasmsg = 0;
	for (j=0; j<6; j++)
		pptr->pname[j] = "prnull"[j];
	pptr->pstklen = NULLSTK;
	pptr->plimit = (unsigned)maxaddr - NULLSTK;
	pptr->pbase = (unsigned)maxaddr;
	pptr->paddr = (unsigned)nulluser;
	pptr->pargs = 0;
	currpid = NULLPROC;

	for (i=0 ; i<NSEM ; i++) {	/* initialize semaphores */
		(sptr = &semaph[i])->sstate = SFREE;
		sptr->sqtail = 1 + (sptr->sqhead = newqueue());
	}

	rdytail = 1 + (rdyhead=newqueue());/* initialize ready list */

#ifdef	MEMMARK
	_mkinit();			/* initialize memory marking */
#endif
#ifdef	RTCLOCK
	clkinit();			/* initialize r.t.clock	*/
#endif
#ifdef	Ndsk
	dskdbp= mkpool(DBUFSIZ,NDBUFF);	/* initialize disk buffers */
	dskrbp= mkpool(DREQSIZ,NDREQ);
#endif
	for ( i=0 ; i<NDEVS ; i++ )	/* initialize devices */
		init(i);
#ifdef	NNETS
	netinit();			/* initialize networks */
#endif

	return(OK);
}
#ifdef ETHER
/* 
 * initialize the i550. Interrupts must be enabled to complete
 * the initialization.  Create user's main program and exit.
 */

INIT()
{
	open(ETHER);
	resume(
	  create(main,INITSTK+200,INITPRIO,INITNAME,1,0)
	);
}
#endif
