/* 
 * i550write.c - write a packet to Ether via i550 device
 * 
 * Author:	Ralph E. Droms/Thomas Narten
 * 		Dept. of Computer Sciences
 * 		Purdue University
 * Date:	Mon Sep 17 1984
 * Copyright (c) 1984 Ralph E. Droms
 */

#include <conf.h>
#include <proc.h>
#include <i550.h>
#include <kernel.h>

i550write(devptr, pxmit, len)
struct	devsw	*devptr;
struct	edl_xmit *pxmit;
int	len;
{
	int result;
	char ps;

	if (len > MAXPACKET)
		return(SYSERR);

/*
 * Fill out the frame to transmit.
 */

	pxmit -> exm_hdr.eh_rspSocket = currpid;	/* which process to resume*/
	pxmit->exm_hdr.eh_command = EDL_TRANSMIT;	/* what to do with it */
	pxmit->exm_length = max(len, ETHER_MIN_PACKET) + EDL_PACKET_OVHD;
	pxmit->exm_extnsn = 0;
	pxmit->exm_idsId=0;
	pxmit->exm_ext2 = 0;
	pxmit->exm_extLength = 0;		/* in-line data */

/*
 * Send the packet.
 */

	disable(ps);				/* mutex MIP */
	if ( (result = i550tframe(pxmit)) == I550XMITOK) {
	    suspend(currpid);		/* We will be resumed once  */
					/* the packet has been sent */
	} else
	    kprintf("i550write: tframe returned %d\n", result);

	if (control(ETHER, FREE_XMIT_BUF, pxmit) == SYSERR)
	    kprintf("i550write: couldn't relase buffer\n");
	restore(ps);
	return(result);
}
