/* 
 * i550tframe.c - Transmit a frame to i550 via MIP queue
 * 
 * Author:	Ralph E. Droms/Thomas Narten
 * 		Dept. of Computer Sciences
 * 		Purdue University
 * Date:	Fri Sep 21 1984
 * Copyright (c) 1984 Ralph E. Droms
 */
#include <i550.h>
#include <proc.h>
/*
 * i550tframe
 *	550 Transmit Frame
 *
 * Inputs:
 *	frame:	pointer to a edl frame to be sent to the 550
 *
 * A request queue entry is built describing the frame to be
 * sent to the 550.  The procedure i550mxmt() is called to
 * send the frame.  If the frame could not be sent, a FALSE value
 * is returned by the procedure and the result field in the
 * edl frame header updated to indicate that the frame could
 * not be sent.  The "response-socket" field of the frame is set
 * to LOCAL_SOCKET_ID (ie, us).
 *
 * Assumes caller completely filled out frame.
 * Assumes caller set up "process_id" field of frame as address of procedure
 *	to call when the frame has been processed by the 550.
 * Assumes caller arranged mutex of MIP Q's (either via SPL or interrupt).
 * Assumes "supply-buf" function wants to supply the whole buffer.
 */

static int i550dlen[] = {			/* 550 frame data-length's */
	0,					/* No command "0" */
	sizeof (struct edl_conn),		/* EDL_CONNECT */
	sizeof (struct edl_disc),		/* EDL_DISCONNECT */
	sizeof (struct edl_amcid),		/* EDL_ADDMCID */
	sizeof (struct edl_dmcid),		/* EDL_DELETEMCID */
	sizeof (struct edl_xmit),		/* EDL_TRANSMIT */
	sizeof (struct edl_sbuf),		/* EDL_SUPPLYBUF */
	0,					/* No command "7" */
	sizeof (struct edl_read),		/* EDL_READ */
	sizeof (struct edl_read)		/* EDL_READC */
};

i550tframe(frame)
register struct edl_hdr *frame;
{
	struct mip_rqe	rqe;
	register int	status;

	/*
	 * Fill out rqe.
	 */

	rqe.r_request	= MIP_SEND_COMMAND;
	rqe.r_sReqId	= frame -> eh_command;
	rqe.r_dDevId	= I550_DEVICE_ID;
	rqe.r_dPortId	= I550_PORT_ID;
	rqe.r_sDevId	= LOCAL_DEVICE_ID;
	rqe.r_idsId	= I550_IDS_ID;
	rqe.r_oDevId	= LOCAL_DEVICE_ID;

	SELECTOROF(rqe.r_dataPtr) = 0;
	OFFSETOF(rqe.r_dataPtr) = (short) frame;	/* GACK! */

	SHORT(rqe.r_dataLen) = i550dlen[frame->eh_command];
	if (frame->eh_command == EDL_TRANSMIT)
		SHORT(rqe.r_dataLen) += ((struct edl_sbuf *)frame)->esb_length
				       - EDL_PACKET_OVHD - MAXPACKET;

/*	frame->eh_rspSocket = LOCAL_SOCKET_ID; */

	/*
	 * Try to transmit rqe to the 550.
	 * Note: must mutex against usage by interrupts.
	 */

	status = i550mxmt(&rqe);

	if (!status)
		frame->eh_result = EDL_FRAME_NOT_DELIVERED;

	return(status);
}

