/* 
 * i550read.c - Xinu interface to read a packet from i550 controller
 * 
 * Author:	Ralph E. Droms/Thomas Narten
 * 		Dept. of Computer Sciences
 * 		Purdue University
 * Date:	Mon Sep 17 1984
 * Copyright (c) 1984 Ralph E. Droms
 */

#include <conf.h>
#include <proc.h>
#include <i550.h>
#include <kernel.h>


i550read(devptr)
struct	devsw	*devptr;
{
    struct edl_sbuf *psbuf;
    char	ps;
    disable(ps);
    if (wait(i550.read_sem) == SYSERR) {
        kprintf("i550read: couldn't wait on readsem.\n");
	restore(ps);
	return(SYSERR);
    }
    psbuf = i550.rgpsbuf[i550.hd_sbuf++];
    if (i550.hd_sbuf >= NSBUF)
        i550.hd_sbuf = 0;
    restore(ps);
    return((int) psbuf);
}
